/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import java.lang.reflect.Field;
import org.garret.jsql.Node;
import org.garret.jsql.SearchThread;

class ElementNode
extends Node {
    String arrayName;
    Field field;
    Class type;

    public boolean equals(Object o) {
        return o instanceof ElementNode && ElementNode.equalObjects(((ElementNode)o).arrayName, this.arrayName) && ElementNode.equalObjects(((ElementNode)o).field, this.field) && ElementNode.equalObjects(((ElementNode)o).type, this.type);
    }

    ElementNode(String array, Field f) {
        super(ElementNode.getFieldType(f.getType()), 112);
        this.arrayName = array;
        this.type = f.getType();
        this.field = f;
    }

    String getFieldName() {
        return this.arrayName != null ? this.arrayName + "." + this.field.getName() : null;
    }

    boolean evaluateBool(SearchThread t) {
        try {
            return this.field.getBoolean(t.containsElem);
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    long evaluateInt(SearchThread t) {
        try {
            return this.field.getLong(t.containsElem);
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    double evaluateReal(SearchThread t) {
        try {
            return this.field.getDouble(t.containsElem);
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    String evaluateStr(SearchThread t) {
        try {
            return (String)this.field.get(t.containsElem);
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    Object evaluateObj(SearchThread t) {
        try {
            return this.field.get(t.containsElem);
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    Class getType() {
        return this.type;
    }
}

