/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.garret.jsql.ArrayIterator;
import org.garret.jsql.Query;

public class IndexedArrayIterator
extends ArrayIterator {
    private final Map indexes = new HashMap();

    public void addIndex(String field) {
        this.indexes.put(field, new HashMap());
    }

    private void addToIndexes(Object obj) {
        Iterator it = this.indexes.keySet().iterator();
        while (it.hasNext()) {
            String field = (String)it.next();
            Collection keys = this.getKeys(field, obj);
            Iterator them = keys.iterator();
            while (them.hasNext()) {
                this.addToIndex(field, them.next(), obj);
            }
        }
    }

    private void addToIndex(String index, Object key, Object value) {
        Map idx = (Map)this.indexes.get(index);
        HashSet<Object> col = (HashSet<Object>)idx.get(key = Query.normalizeKeyValue(key));
        if (col == null) {
            col = new HashSet<Object>();
            idx.put(key, col);
        }
        col.add(value);
    }

    private void removeFromIndexes(Object obj) {
        Iterator it = this.indexes.keySet().iterator();
        while (it.hasNext()) {
            String field = (String)it.next();
            Collection keys = this.getKeys(field, obj);
            Iterator them = keys.iterator();
            while (them.hasNext()) {
                this.removeFromIndex(field, them.next(), obj);
            }
        }
    }

    private void removeFromIndex(String index, Object key, Object value) {
        Map idx = (Map)this.indexes.get(index);
        Collection col = (Collection)idx.get(key = Query.normalizeKeyValue(key));
        if (col != null) {
            col.remove(value);
        }
    }

    private Collection getKeys(String field, Object obj) {
        HashSet<Object> keys = new HashSet<Object>();
        HashSet<Object> roots = new HashSet<Object>();
        int dot = field.lastIndexOf(46);
        if (dot > -1) {
            String root = field.substring(0, dot);
            field = field.substring(dot + 1);
            roots.addAll(this.getKeys(root, obj));
        } else {
            roots.add(obj);
        }
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            try {
                Field f = o.getClass().getDeclaredField(field);
                f.setAccessible(true);
                Object key = f.get(o);
                if (key instanceof Collection) {
                    keys.addAll((Collection)key);
                    continue;
                }
                if (key.getClass().isArray()) {
                    Object[] a = (Object[])key;
                    for (int i = 0; i < a.length; ++i) {
                        keys.add(a[i]);
                    }
                    continue;
                }
                keys.add(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return keys;
    }

    public void add(Object obj) {
        super.add(obj);
        this.addToIndexes(obj);
    }

    public boolean getByKeyRange(String key, Object minValue, Object maxValue, boolean inclusive, Query result) {
        Map idx;
        System.out.println("Requesting index [" + key + "]");
        if (minValue == maxValue && (idx = (Map)this.indexes.get(key)) != null) {
            Collection col = (Collection)idx.get(minValue);
            if (col != null) {
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    result.add(it.next());
                }
            }
            return true;
        }
        return false;
    }

    public void remove(int index) {
        this.remove(this.arr.get(index));
    }

    public void remove(Object obj) {
        this.arr.remove(obj);
        this.removeFromIndexes(obj);
    }
}

