/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.garret.jsql.JSQLNoSuchFieldException;
import org.garret.jsql.JSQLNullPointerException;
import org.garret.jsql.Node;
import org.garret.jsql.Query;
import org.garret.jsql.SearchThread;

class InvokeAnyNode
extends Node {
    Node target;
    Node[] arguments;
    Class[] profile;
    String methodName;
    String containsFieldName;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;

    public boolean equals(Object o) {
        if (!(o instanceof InvokeAnyNode)) {
            return false;
        }
        InvokeAnyNode node = (InvokeAnyNode)o;
        return InvokeAnyNode.equalObjects(node.target, this.target) && Arrays.equals(node.arguments, this.arguments) && Arrays.equals(node.profile, this.profile) && InvokeAnyNode.equalObjects(node.methodName, this.methodName) && InvokeAnyNode.equalObjects(node.containsFieldName, this.containsFieldName);
    }

    Class getType() {
        return class$java$lang$Object == null ? (class$java$lang$Object = InvokeAnyNode.class$("java.lang.Object")) : class$java$lang$Object;
    }

    String getFieldName() {
        if (this.target != null) {
            if (this.target.tag != 67) {
                String baseName = this.target.getFieldName();
                return baseName != null ? baseName + "." + this.methodName : null;
            }
            return this.methodName;
        }
        return this.containsFieldName != null ? this.containsFieldName + "." + this.methodName : this.methodName;
    }

    InvokeAnyNode(Node target, String name, Node[] arguments, String containsFieldName) {
        super(19, 102);
        this.target = target;
        this.containsFieldName = containsFieldName;
        this.methodName = name;
        this.arguments = arguments;
        this.profile = new Class[arguments.length];
    }

    Object evaluateObj(SearchThread t) {
        Class<?> cls;
        Object obj = t.currObj;
        if (this.target != null && (obj = this.target.evaluateObj(t)) == null) {
            throw new JSQLNullPointerException(null, this.methodName);
        }
        Object[] parameters = null;
        int n = this.arguments.length;
        if (n > 0) {
            parameters = new Object[n];
            for (int i = 0; i < n; ++i) {
                Class<Constable> type;
                Object value;
                Node arg = this.arguments[i];
                switch (arg.type) {
                    case 1: {
                        value = new Long(arg.evaluateInt(t));
                        type = Long.TYPE;
                        break;
                    }
                    case 2: {
                        value = new Double(arg.evaluateReal(t));
                        type = Double.TYPE;
                        break;
                    }
                    case 6: {
                        value = arg.evaluateStr(t);
                        type = class$java$lang$String == null ? InvokeAnyNode.class$("java.lang.String") : class$java$lang$String;
                        break;
                    }
                    case 0: {
                        value = new Boolean(arg.evaluateBool(t));
                        type = Boolean.TYPE;
                        break;
                    }
                    default: {
                        value = arg.evaluateObj(t);
                        if (value != null) {
                            type = value.getClass();
                            if (type.equals(class$java$lang$Long == null ? InvokeAnyNode.class$("java.lang.Long") : class$java$lang$Long) || type.equals(class$java$lang$Integer == null ? InvokeAnyNode.class$("java.lang.Integer") : class$java$lang$Integer) || type.equals(class$java$lang$Byte == null ? InvokeAnyNode.class$("java.lang.Byte") : class$java$lang$Byte) || type.equals(class$java$lang$Character == null ? InvokeAnyNode.class$("java.lang.Character") : class$java$lang$Character) || type.equals(class$java$lang$Short == null ? InvokeAnyNode.class$("java.lang.Short") : class$java$lang$Short)) {
                                type = Long.TYPE;
                                break;
                            }
                            if (type.equals(class$java$lang$Float == null ? InvokeAnyNode.class$("java.lang.Float") : class$java$lang$Float) || type.equals(class$java$lang$Double == null ? InvokeAnyNode.class$("java.lang.Double") : class$java$lang$Double)) {
                                type = Double.TYPE;
                                break;
                            }
                            if (!type.equals(class$java$lang$Boolean == null ? InvokeAnyNode.class$("java.lang.Boolean") : class$java$lang$Boolean)) break;
                            type = Boolean.TYPE;
                            break;
                        }
                        type = class$java$lang$Object == null ? InvokeAnyNode.class$("java.lang.Object") : class$java$lang$Object;
                    }
                }
                parameters[i] = value;
                this.profile[i] = type;
            }
        }
        try {
            Method m;
            if (this.target == null && t.containsElem != null && (m = Query.lookupMethod(t.containsElem.getClass(), this.methodName, this.profile)) != null) {
                return t.query.resolve(m.invoke(t.containsElem, parameters));
            }
            cls = obj.getClass();
            m = Query.lookupMethod(cls, this.methodName, this.profile);
            if (m != null) {
                return t.query.resolve(m.invoke(t.containsElem, parameters));
            }
        }
        catch (InvocationTargetException x) {
            x.printStackTrace();
            throw new IllegalAccessError();
        }
        catch (IllegalAccessException x) {
            x.printStackTrace();
            throw new IllegalAccessError();
        }
        throw new JSQLNoSuchFieldException(cls, this.methodName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

