/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.garret.jsql.JSQLNullPointerException;
import org.garret.jsql.Node;
import org.garret.jsql.SearchThread;

class InvokeNode
extends Node {
    Node target;
    Node[] arguments;
    Method mth;

    public boolean equals(Object o) {
        return o instanceof InvokeNode && InvokeNode.equalObjects(((InvokeNode)o).target, this.target) && Arrays.equals(((InvokeNode)o).arguments, this.arguments) && InvokeNode.equalObjects(((InvokeNode)o).mth, this.mth);
    }

    Class getType() {
        return this.mth.getReturnType();
    }

    String getFieldName() {
        if (this.target != null && this.target.tag != 67) {
            String baseName = this.target.getFieldName();
            return baseName != null ? baseName + "." + this.mth.getName() : null;
        }
        return this.mth.getName();
    }

    Object getTarget(SearchThread t) {
        if (this.target == null) {
            return t.currObj;
        }
        Object obj = this.target.evaluateObj(t);
        if (obj == null) {
            throw new JSQLNullPointerException(this.target.getType(), this.mth.toString());
        }
        return obj;
    }

    Object[] evaluateArguments(SearchThread t) {
        Object[] parameters = null;
        int n = this.arguments.length;
        if (n > 0) {
            parameters = new Object[n];
            for (int i = 0; i < n; ++i) {
                Object value;
                Node arg = this.arguments[i];
                switch (arg.type) {
                    case 1: {
                        value = new Long(arg.evaluateInt(t));
                        break;
                    }
                    case 2: {
                        value = new Double(arg.evaluateReal(t));
                        break;
                    }
                    case 6: {
                        value = arg.evaluateStr(t);
                        break;
                    }
                    case 0: {
                        value = new Boolean(arg.evaluateBool(t));
                        break;
                    }
                    default: {
                        value = arg.evaluateObj(t);
                    }
                }
                parameters[i] = value;
            }
        }
        return parameters;
    }

    long evaluateInt(SearchThread t) {
        Object obj = this.getTarget(t);
        Object[] parameters = this.evaluateArguments(t);
        try {
            return ((Number)this.mth.invoke(obj, parameters)).longValue();
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new Error("Method invocation error");
        }
    }

    double evaluateReal(SearchThread t) {
        Object obj = this.getTarget(t);
        Object[] parameters = this.evaluateArguments(t);
        try {
            return ((Number)this.mth.invoke(obj, parameters)).doubleValue();
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new Error("Method invocation error");
        }
    }

    boolean evaluateBool(SearchThread t) {
        Object obj = this.getTarget(t);
        Object[] parameters = this.evaluateArguments(t);
        try {
            return (Boolean)this.mth.invoke(obj, parameters);
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new Error("Method invocation error");
        }
    }

    String evaluateStr(SearchThread t) {
        Object obj = this.getTarget(t);
        Object[] parameters = this.evaluateArguments(t);
        try {
            return (String)this.mth.invoke(obj, parameters);
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new Error("Method invocation error");
        }
    }

    Object evaluateObj(SearchThread t) {
        Object obj = this.getTarget(t);
        Object[] parameters = this.evaluateArguments(t);
        try {
            return this.mth.invoke(obj, parameters);
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new Error("Method invocation error");
        }
    }

    InvokeNode(Node target, Method mth, Node[] arguments) {
        super(InvokeNode.getFieldType(mth.getReturnType()), 71);
        this.target = target;
        this.arguments = arguments;
        this.mth = mth;
    }
}

