/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import java.lang.reflect.Field;
import org.garret.jsql.JSQLNullPointerException;
import org.garret.jsql.Node;
import org.garret.jsql.SearchThread;

class LoadNode
extends Node {
    Field field;
    Node base;

    public boolean equals(Object o) {
        return o instanceof LoadNode && super.equals(o) && ((LoadNode)o).field.equals(this.field) && LoadNode.equalObjects(((LoadNode)o).base, this.base);
    }

    Class getType() {
        return this.field.getType();
    }

    String getFieldName() {
        if (this.base != null && this.base.tag != 67) {
            String baseName = this.base.getFieldName();
            return baseName != null ? baseName + "." + this.field.getName() : null;
        }
        return this.field.getName();
    }

    final Object getBase(SearchThread t) {
        if (this.base == null) {
            return t.currObj;
        }
        Object obj = this.base.evaluateObj(t);
        if (obj == null) {
            throw new JSQLNullPointerException(this.base.getType(), this.field.getName());
        }
        return obj;
    }

    long evaluateInt(SearchThread t) {
        try {
            return this.field.getLong(this.getBase(t));
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    double evaluateReal(SearchThread t) {
        try {
            return this.field.getDouble(this.getBase(t));
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    boolean evaluateBool(SearchThread t) {
        try {
            return this.field.getBoolean(this.getBase(t));
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    String evaluateStr(SearchThread t) {
        try {
            return (String)this.field.get(this.getBase(t));
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    Object evaluateObj(SearchThread t) {
        try {
            return this.field.get(this.getBase(t));
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    LoadNode(Node base, Field f) {
        super(LoadNode.getFieldType(f.getType()), 100);
        this.field = f;
        this.base = base;
    }
}

