/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.garret.jsql.Query;

class OrderNode {
    OrderNode next;
    boolean ascent;
    Field field;
    Method method;
    String fieldName;
    int type;
    static final int fdBool = 0;
    static final int fdChar = 1;
    static final int fdInt1 = 2;
    static final int fdInt2 = 3;
    static final int fdInt4 = 4;
    static final int fdInt8 = 5;
    static final int fdReal4 = 6;
    static final int fdReal8 = 7;
    static final int fdObj = 8;

    final int compare(Object a, Object b) {
        int n;
        int diff;
        try {
            if (this.method != null) {
                diff = ((Comparable)this.method.invoke(a, null)).compareTo(this.method.invoke(b, null));
            } else {
                switch (this.type) {
                    case 0: {
                        diff = this.field.getBoolean(a) ? (this.field.getBoolean(b) ? 0 : 1) : (this.field.getBoolean(b) ? -1 : 0);
                        break;
                    }
                    case 1: {
                        diff = this.field.getChar(a) - this.field.getChar(b);
                        break;
                    }
                    case 2: {
                        diff = this.field.getByte(a) - this.field.getByte(b);
                        break;
                    }
                    case 3: {
                        diff = this.field.getShort(a) - this.field.getShort(b);
                        break;
                    }
                    case 4: {
                        int l = this.field.getInt(a);
                        int r = this.field.getInt(b);
                        diff = l < r ? -1 : (l == r ? 0 : 1);
                        break;
                    }
                    case 5: {
                        long l = this.field.getLong(a);
                        long r = this.field.getLong(b);
                        diff = l < r ? -1 : (l == r ? 0 : 1);
                        break;
                    }
                    case 6: {
                        float l = this.field.getFloat(a);
                        float r = this.field.getFloat(b);
                        diff = l < r ? -1 : (l == r ? 0 : 1);
                        break;
                    }
                    case 7: {
                        double l = this.field.getDouble(a);
                        double r = this.field.getDouble(b);
                        diff = l < r ? -1 : (l == r ? 0 : 1);
                        break;
                    }
                    case 8: {
                        diff = ((Comparable)this.field.get(a)).compareTo(this.field.get(b));
                        break;
                    }
                    default: {
                        throw new Error("Invalid order by type tag: " + this.type);
                    }
                }
            }
        }
        catch (IllegalAccessException x) {
            x.printStackTrace();
            throw new IllegalAccessError();
        }
        catch (InvocationTargetException x) {
            x.printStackTrace();
            throw new IllegalAccessError();
        }
        if (diff == 0 && this.next != null) {
            return this.next.compare(a, b);
        }
        if (!this.ascent) {
            n = -diff;
        }
        return n;
    }

    void resolveName(Class cls) {
        this.field = Query.lookupField(cls, this.fieldName);
        if (this.field == null) {
            this.method = Query.lookupMethod(cls, this.fieldName, Query.defaultProfile);
            if (this.method == null) {
                throw new NoSuchFieldError(this.fieldName);
            }
        }
    }

    OrderNode(int type, Field field) {
        this.type = type;
        this.field = field;
        this.ascent = true;
    }

    OrderNode(Method method) {
        this.method = method;
        this.ascent = true;
    }

    OrderNode(String name) {
        this.fieldName = name;
        this.ascent = true;
    }
}

