/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.garret.jsql.NoIndexException;
import org.garret.jsql.Query;
import org.garret.jsql.QueryIterator;

public class RecursiveIterator
implements QueryIterator {
    HashSet markedSet;
    Object[] stack;
    Object root;
    Reference[] references;
    int sp;

    public RecursiveIterator(Object root, Reference[] references) {
        this.root = root;
        this.references = references;
        for (int i = 0; i < references.length; ++i) {
            Reference r = references[i];
            try {
                if (r.cls == null) {
                    r.cls = Class.forName(r.className);
                }
                if (r.field != null) continue;
                r.field = r.cls.getDeclaredField(r.fieldName);
                r.field.setAccessible(true);
                continue;
            }
            catch (ClassNotFoundException x) {
                throw new NoClassDefFoundError(r.className);
            }
            catch (NoSuchFieldException x) {
                throw new NoSuchFieldError(r.fieldName);
            }
        }
        this.markedSet = new HashSet();
        this.stack = new Object[64];
    }

    final void push(Object o) {
        if (this.sp == this.stack.length) {
            Object[] newStack = new Object[this.sp * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.sp);
            this.stack = newStack;
        }
        this.stack[this.sp++] = o;
    }

    final Object pop() {
        return this.sp > 0 ? this.stack[--this.sp] : null;
    }

    public Object getFirst() {
        this.markedSet.clear();
        this.sp = 0;
        this.push(this.root);
        this.markedSet.add(new MarkedObject(this.root));
        return this.getNext(null, 0);
    }

    public Object getNext(Object prevObj, int prevIndex) {
        try {
            Object o = this.pop();
            if (o != null) {
                int n = this.references.length;
                for (int i = 0; i < n; ++i) {
                    Object next;
                    if (!this.references[i].cls.isAssignableFrom(o.getClass()) || (next = this.references[i].field.get(o)) == null) continue;
                    if (next instanceof Collection) {
                        Iterator iterator = ((Collection)next).iterator();
                        while ((next = iterator.next()) != null) {
                            if (!this.markedSet.add(new MarkedObject(next))) continue;
                            this.push(next);
                        }
                        continue;
                    }
                    if (next.getClass().isArray()) {
                        Object[] arr = (Object[])next;
                        for (int j = 0; j < arr.length; ++j) {
                            if (arr[j] == null || !this.markedSet.add(new MarkedObject(arr[j]))) continue;
                            this.push(arr[j]);
                        }
                        continue;
                    }
                    if (!this.markedSet.add(new MarkedObject(next))) continue;
                    this.push(next);
                }
            }
            return o;
        }
        catch (IllegalAccessException x) {
            x.printStackTrace();
            throw new IllegalAccessError();
        }
    }

    public Object getByPrimaryKey(String key, Object keyValue) {
        throw new NoIndexException();
    }

    public boolean getByKeyRange(String key, Object minValue, Object maxValue, boolean inclusive, Query result) {
        return false;
    }

    public QueryIterator concurrentIterator() {
        return null;
    }

    public boolean isThreadSafe() {
        return false;
    }

    public boolean useNormalizedKeys() {
        return true;
    }

    static class MarkedObject {
        Object o;

        public int hashCode() {
            return this.o.hashCode();
        }

        public boolean equals(Object mo) {
            return this.o == ((MarkedObject)mo).o;
        }

        MarkedObject(Object o) {
            this.o = o;
        }
    }

    public static class Reference {
        public Class cls;
        public String className;
        public Field field;
        public String fieldName;

        public Reference(Class cls, String fieldName) {
            this.cls = cls;
            this.fieldName = fieldName;
        }

        public Reference(String className, String fieldName) {
            this.className = className;
            this.fieldName = fieldName;
        }
    }
}

