/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import org.garret.jsql.JSQLRuntimeException;
import org.garret.jsql.Node;
import org.garret.jsql.OrderNode;
import org.garret.jsql.Query;
import org.garret.jsql.QueryIterator;
import org.garret.jsql.ThreadPool;

class SearchThread
implements Runnable {
    int id;
    Query query;
    Object[] selection = new Object[1024];
    int used = 0;
    int pos = 0;
    int allocated = 1024;
    int[] indexVar = new int[32];
    long[] intAggragateFuncValue;
    double[] realAggragateFuncValue;
    Object[] containsArray;
    Object currObj;
    Object containsElem;
    QueryIterator iterator;
    Thread thread;
    static final int initSize = 1024;
    static final int maxIndexVars = 32;

    void reset() {
        this.used = 0;
        this.pos = 0;
    }

    SearchThread(int id, int nThreads, Query query, QueryIterator iterator) {
        this.id = id;
        this.query = query;
        this.iterator = iterator;
    }

    void start() {
        this.thread = ThreadPool.getInstance().start(this);
    }

    void join() throws InterruptedException {
        ThreadPool.getInstance().join(this.thread);
    }

    boolean add(Object obj) {
        if (this.used == this.allocated) {
            this.allocated *= 2;
            Object[] newbuf = new Object[this.allocated];
            System.arraycopy(this.selection, 0, newbuf, 0, this.used);
            this.selection = newbuf;
        }
        this.selection[this.used] = obj;
        return ++this.used != this.query.limit;
    }

    public void run() {
        Node tree = this.query.tree;
        QueryIterator iterator = this.iterator;
        int n = this.query.nThreads;
        int limit = this.query.limit;
        this.currObj = iterator.getFirst();
        int i = 0;
        int j = this.id;
        while (--j >= 0 && this.currObj != null) {
            this.currObj = iterator.getNext(this.currObj, i);
            ++i;
        }
        while (this.currObj != null) {
            try {
                if (tree.evaluateBool(this) && !this.add(this.currObj)) {
                    break;
                }
            }
            catch (JSQLRuntimeException x) {
                this.query.reportRuntimeError(x);
            }
            this.currObj = iterator.getNext(this.currObj, i++);
            j = n;
            while (this.currObj != null && --j != 0) {
                this.currObj = iterator.getNext(this.currObj, i);
                ++i;
            }
        }
        if (this.query.order != null) {
            this.sort();
        }
    }

    void sort() {
        Object top;
        int k;
        int i;
        OrderNode order = this.query.order;
        if (this.used == 0) {
            return;
        }
        OrderNode ord = order;
        while (ord != null) {
            if (ord.fieldName != null) {
                ord.resolveName(this.selection[0].getClass());
            }
            ord = ord.next;
        }
        int n = this.used;
        int j = i = n / 2;
        while (i >= 1) {
            k = i;
            top = this.selection[k - 1];
            do {
                if (k * 2 == n || order.compare(this.selection[k * 2 - 1], this.selection[k * 2]) > 0) {
                    if (order.compare(top, this.selection[k * 2 - 1]) >= 0) break;
                    this.selection[k - 1] = this.selection[k * 2 - 1];
                    k *= 2;
                    continue;
                }
                if (order.compare(top, this.selection[k * 2]) >= 0) break;
                this.selection[k - 1] = this.selection[k * 2];
                k = k * 2 + 1;
            } while (k <= j);
            this.selection[k - 1] = top;
            --i;
        }
        for (i = n; i >= 2; --i) {
            top = this.selection[i - 1];
            this.selection[i - 1] = this.selection[0];
            this.selection[0] = top;
            k = 1;
            j = (i - 1) / 2;
            while (k <= j) {
                if (k * 2 == i - 1 || order.compare(this.selection[k * 2 - 1], this.selection[k * 2]) > 0) {
                    if (order.compare(top, this.selection[k * 2 - 1]) >= 0) break;
                    this.selection[k - 1] = this.selection[k * 2 - 1];
                    k *= 2;
                    continue;
                }
                if (order.compare(top, this.selection[k * 2]) >= 0) break;
                this.selection[k - 1] = this.selection[k * 2];
                k = k * 2 + 1;
            }
            this.selection[k - 1] = top;
        }
    }
}

