/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.garret.jsql.PageReference;
import org.garret.jsql.Query;
import org.garret.jsql.TTreePage;

public class TTree
implements Serializable {
    TTreePage root;
    int size;
    Field field;

    public TTree(Field f) {
        this.field = f;
    }

    public void select(Object minValue, Object maxValue, boolean inclusive, Query query) {
        if (this.root != null) {
            try {
                this.root.find(this.field, (Comparable)minValue, (Comparable)maxValue, inclusive ? 1 : 0, query);
            }
            catch (IllegalAccessException x) {
                throw new IllegalAccessError();
            }
        }
    }

    public void add(Object obj) {
        if (this.root == null) {
            this.root = new TTreePage(obj);
        } else {
            try {
                PageReference ref = new PageReference(this.root);
                this.root.insert(this.field, obj, (Comparable)this.field.get(obj), ref);
                this.root = ref.pg;
            }
            catch (IllegalAccessException x) {
                x.printStackTrace();
                throw new IllegalAccessError();
            }
        }
        ++this.size;
    }

    public void remove(Object obj) {
        try {
            PageReference ref = new PageReference(this.root);
            this.root.remove(this.field, obj, (Comparable)this.field.get(obj), ref);
            this.root = ref.pg;
            --this.size;
        }
        catch (IllegalAccessException x) {
            throw new IllegalAccessError();
        }
    }

    public void clear() {
        this.root = null;
        this.size = 0;
    }

    public void traverseForward(Processor proc) {
        if (this.root != null) {
            this.root.traverseForward(proc);
        }
    }

    public void traverseBackward(Processor proc) {
        if (this.root != null) {
            this.root.traverseBackward(proc);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.size = s.readInt();
        Class cls = (Class)s.readObject();
        String fieldName = (String)s.readObject();
        try {
            this.field = cls.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException x) {
            throw new NoSuchFieldError(fieldName);
        }
        this.field.setAccessible(true);
        if (this.size > 0) {
            this.root = new TreeConstructor(s).reconstructTree(this.size);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.size);
        s.writeObject(this.field.getDeclaringClass());
        s.writeObject(this.field.getName());
        this.traverseForward(new TreeSerializer(s));
    }

    static class TreeConstructor {
        int height;
        ObjectInputStream in;

        TreeConstructor(ObjectInputStream s) {
            this.in = s;
        }

        void readPage(TTreePage pg) throws IOException, ClassNotFoundException {
            int n = pg.nItems;
            for (int i = 0; i < n; ++i) {
                pg.item[i] = this.in.readObject();
            }
        }

        TTreePage reconstructTree(int n) throws IOException, ClassNotFoundException {
            TTreePage root;
            if (n <= 125) {
                ++this.height;
                root = new TTreePage(n);
                this.readPage(root);
            } else if (n <= 250) {
                this.height += 2;
                root = new TTreePage(125);
                root.left = new TTreePage(n - 125);
                this.readPage(root.left);
                this.readPage(root);
                root.balance = -1;
            } else {
                root = new TTreePage(125);
                int less = n - 125 >>> 1;
                int greater = n - 125 - less;
                int rootHeight = ++this.height;
                root.left = this.reconstructTree(less);
                int leftHeight = this.height;
                this.readPage(root);
                this.height = rootHeight;
                root.right = this.reconstructTree(greater);
                int rightHeight = this.height;
                if (leftHeight > rightHeight) {
                    root.balance = -1;
                    this.height = leftHeight;
                } else if (leftHeight < rightHeight) {
                    root.balance = 1;
                    this.height = rightHeight;
                } else {
                    this.height = leftHeight;
                }
            }
            return root;
        }
    }

    static class TreeSerializer
    implements Processor {
        ObjectOutputStream out;

        TreeSerializer(ObjectOutputStream s) {
            this.out = s;
        }

        public void process(Object o) {
            try {
                this.out.writeObject(o);
            }
            catch (IOException x) {
                throw new Error("Failed to serialize T-Tree: " + x);
            }
        }
    }

    public static interface Processor {
        public void process(Object var1);
    }
}

