/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.garret.jsql.PageReference;
import org.garret.jsql.Query;
import org.garret.jsql.TTree;

class TTreePage
implements Serializable {
    TTreePage left;
    TTreePage right;
    int balance;
    int nItems;
    Object[] item;
    static final int pageSize = 125;
    static final int minItems = 123;

    TTreePage(Object rec) {
        this.nItems = 1;
        this.item = new Object[125];
        this.item[0] = rec;
    }

    boolean find(Field field, Comparable minValue, Comparable maxValue, int inclusive, Query q) throws IllegalAccessException {
        int n = this.nItems;
        if (minValue != null && minValue.compareTo(field.get(this.item[0])) >= inclusive) {
            if (minValue.compareTo(field.get(this.item[n - 1])) >= inclusive) {
                if (this.right != null) {
                    return this.right.find(field, minValue, maxValue, inclusive, q);
                }
                return true;
            }
            int l = 0;
            int r = n;
            while (l < r) {
                int m = l + r >> 1;
                if (minValue.compareTo(field.get(this.item[m])) >= inclusive) {
                    l = m + 1;
                    continue;
                }
                r = m;
            }
            while (r < n) {
                if (maxValue != null && -maxValue.compareTo(field.get(this.item[r])) >= inclusive) {
                    return false;
                }
                if (q.add(this.item[r++])) continue;
                return false;
            }
            if (this.right != null) {
                return this.right.find(field, minValue, maxValue, inclusive, q);
            }
            return true;
        }
        if (this.left != null && !this.left.find(field, minValue, maxValue, inclusive, q)) {
            return false;
        }
        for (int l = 0; l < n; ++l) {
            if (maxValue != null && -maxValue.compareTo(field.get(this.item[l])) >= inclusive) {
                return false;
            }
            if (q.add(this.item[l])) continue;
            return false;
        }
        if (this.right != null) {
            return this.right.find(field, minValue, maxValue, inclusive, q);
        }
        return true;
    }

    boolean insert(Field field, Object obj, Comparable key, PageReference ref) throws IllegalAccessException {
        Object reinsertItem;
        int i;
        int n = this.nItems;
        int diff = key.compareTo(field.get(this.item[0]));
        if (diff <= 0) {
            if ((this.left == null || diff == 0) && this.nItems != 125) {
                for (int i2 = n; i2 > 0; --i2) {
                    this.item[i2] = this.item[i2 - 1];
                }
                this.item[0] = obj;
                ++this.nItems;
                return false;
            }
            if (this.left == null) {
                this.left = new TTreePage(obj);
            } else {
                TTreePage pg = ref.pg;
                ref.pg = this.left;
                boolean grow = this.left.insert(field, obj, key, ref);
                this.left = ref.pg;
                ref.pg = pg;
                if (!grow) {
                    return false;
                }
            }
            if (this.balance > 0) {
                this.balance = 0;
                return false;
            }
            if (this.balance == 0) {
                this.balance = -1;
                return true;
            }
            TTreePage left = this.left;
            if (left.balance < 0) {
                this.left = left.right;
                left.right = this;
                this.balance = 0;
                left.balance = 0;
                ref.pg = left;
            } else {
                TTreePage right = left.right;
                left.right = right.left;
                right.left = left;
                this.left = right.right;
                right.right = this;
                this.balance = right.balance < 0 ? 1 : 0;
                left.balance = right.balance > 0 ? -1 : 0;
                right.balance = 0;
                ref.pg = right;
            }
            return false;
        }
        diff = key.compareTo(field.get(this.item[n - 1]));
        if (diff >= 0) {
            if ((this.right == null || diff == 0) && this.nItems != 125) {
                this.item[n] = obj;
                ++this.nItems;
                return false;
            }
            if (this.right == null) {
                this.right = new TTreePage(obj);
            } else {
                TTreePage pg = ref.pg;
                ref.pg = this.right;
                boolean grow = this.right.insert(field, obj, key, ref);
                this.right = ref.pg;
                ref.pg = pg;
                if (!grow) {
                    return false;
                }
            }
            if (this.balance < 0) {
                this.balance = 0;
                return false;
            }
            if (this.balance == 0) {
                this.balance = 1;
                return true;
            }
            TTreePage right = this.right;
            if (right.balance > 0) {
                this.right = right.left;
                right.left = this;
                this.balance = 0;
                right.balance = 0;
                ref.pg = right;
            } else {
                TTreePage left = right.left;
                right.left = left.right;
                left.right = right;
                this.right = left.left;
                left.left = this;
                this.balance = left.balance > 0 ? -1 : 0;
                right.balance = left.balance < 0 ? 1 : 0;
                left.balance = 0;
                ref.pg = left;
            }
            return false;
        }
        int l = 1;
        int r = n - 1;
        while (l < r) {
            i = l + r >> 1;
            diff = key.compareTo(field.get(this.item[i]));
            if (diff > 0) {
                l = i + 1;
                continue;
            }
            r = i;
            if (diff != 0) continue;
            break;
        }
        if (n != 125) {
            for (i = n; i > r; --i) {
                this.item[i] = this.item[i - 1];
            }
            this.item[r] = obj;
            ++this.nItems;
            return false;
        }
        if (this.balance >= 0) {
            reinsertItem = this.item[0];
            for (int i3 = 1; i3 < r; ++i3) {
                this.item[i3 - 1] = this.item[i3];
            }
            this.item[r - 1] = obj;
        } else {
            reinsertItem = this.item[n - 1];
            for (int i4 = n - 1; i4 > r; --i4) {
                this.item[i4] = this.item[i4 - 1];
            }
            this.item[r] = obj;
        }
        return this.insert(field, reinsertItem, (Comparable)field.get(reinsertItem), ref);
    }

    int balanceLeftBranch(PageReference ref) throws IllegalAccessException {
        if (this.balance < 0) {
            this.balance = 0;
            return 1;
        }
        if (this.balance == 0) {
            this.balance = 1;
            return 0;
        }
        TTreePage right = this.right;
        if (right.balance >= 0) {
            this.right = right.left;
            right.left = this;
            if (right.balance == 0) {
                this.balance = 1;
                right.balance = -1;
                ref.pg = right;
                return 0;
            }
            this.balance = 0;
            right.balance = 0;
            ref.pg = right;
            return 1;
        }
        TTreePage left = right.left;
        right.left = left.right;
        left.right = right;
        this.right = left.left;
        left.left = this;
        this.balance = left.balance > 0 ? -1 : 0;
        right.balance = left.balance < 0 ? 1 : 0;
        left.balance = 0;
        ref.pg = left;
        return 1;
    }

    int balanceRightBranch(PageReference ref) throws IllegalAccessException {
        if (this.balance > 0) {
            this.balance = 0;
            return 1;
        }
        if (this.balance == 0) {
            this.balance = -1;
            return 0;
        }
        TTreePage left = this.left;
        if (left.balance <= 0) {
            this.left = left.right;
            left.right = this;
            if (left.balance == 0) {
                this.balance = -1;
                left.balance = 1;
                ref.pg = left;
                return 0;
            }
            this.balance = 0;
            left.balance = 0;
            ref.pg = left;
            return 1;
        }
        TTreePage right = left.right;
        left.right = right.left;
        right.left = left;
        this.left = right.right;
        right.right = this;
        this.balance = right.balance < 0 ? 1 : 0;
        left.balance = right.balance > 0 ? -1 : 0;
        right.balance = 0;
        ref.pg = right;
        return 1;
    }

    int remove(Field field, Object obj, Comparable key, PageReference ref) throws IllegalAccessException {
        int h;
        TTreePage pg;
        int n = this.nItems;
        int diff = key.compareTo(field.get(this.item[0]));
        if (diff <= 0 && this.left != null) {
            pg = ref.pg;
            ref.pg = this.left;
            h = this.left.remove(field, obj, key, ref);
            this.left = ref.pg;
            ref.pg = pg;
            if (h > 0) {
                return this.balanceLeftBranch(ref);
            }
            if (h == 0) {
                return 0;
            }
        }
        if ((diff = key.compareTo(field.get(this.item[n - 1]))) <= 0) {
            for (int i = 0; i < n; ++i) {
                if (this.item[i] != obj) continue;
                if (n == 1) {
                    if (this.right == null) {
                        ref.pg = this.left;
                        return 1;
                    }
                    if (this.left == null) {
                        ref.pg = this.right;
                        return 1;
                    }
                }
                if (n <= 123) {
                    if (this.left != null && this.balance <= 0) {
                        TTreePage prev = this.left;
                        while (prev.right != null) {
                            prev = prev.right;
                        }
                        while (--i >= 0) {
                            this.item[i + 1] = this.item[i];
                        }
                        this.item[0] = prev.item[prev.nItems - 1];
                        pg = ref.pg;
                        ref.pg = this.left;
                        int h2 = this.left.remove(field, this.item[0], (Comparable)field.get(this.item[0]), ref);
                        this.left = ref.pg;
                        ref.pg = pg;
                        if (h2 > 0) {
                            h2 = this.balanceLeftBranch(ref);
                        }
                        return h2;
                    }
                    if (this.right != null) {
                        TTreePage next = this.right;
                        while (next.left != null) {
                            next = next.left;
                        }
                        while (++i < n) {
                            this.item[i - 1] = this.item[i];
                        }
                        this.item[n - 1] = next.item[0];
                        pg = ref.pg;
                        ref.pg = this.right;
                        int h3 = this.right.remove(field, this.item[n - 1], (Comparable)field.get(this.item[n - 1]), ref);
                        this.right = ref.pg;
                        ref.pg = pg;
                        if (h3 > 0) {
                            h3 = this.balanceRightBranch(ref);
                        }
                        return h3;
                    }
                }
                while (++i < n) {
                    this.item[i - 1] = this.item[i];
                }
                --this.nItems;
                return 0;
            }
        }
        if (this.right != null) {
            pg = ref.pg;
            ref.pg = this.right;
            h = this.right.remove(field, obj, key, ref);
            this.right = ref.pg;
            ref.pg = pg;
            if (h > 0) {
                return this.balanceRightBranch(ref);
            }
            return h;
        }
        return -1;
    }

    void traverseForward(TTree.Processor proc) {
        if (this.left != null) {
            this.left.traverseForward(proc);
        }
        int n = this.nItems;
        for (int i = 0; i < n; ++i) {
            proc.process(this.item[i]);
        }
        if (this.right != null) {
            this.right.traverseForward(proc);
        }
    }

    void traverseBackward(TTree.Processor proc) {
        if (this.right != null) {
            this.right.traverseForward(proc);
        }
        int i = this.nItems;
        while (--i >= 0) {
            proc.process(this.item[i]);
        }
        if (this.left != null) {
            this.left.traverseForward(proc);
        }
    }

    TTreePage(int n) {
        this.nItems = n;
        this.item = new Object[125];
    }
}

