/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

public class ThreadPool {
    PooledThread availableThreadList;
    int nActiveThreads;
    int deficit;
    int maxThreads;
    boolean closed;
    static ThreadPool theInstance = new ThreadPool();

    public static ThreadPool getInstance() {
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Thread start(Runnable task) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            while (true) {
                if (this.availableThreadList != null) {
                    PooledThread thread = this.availableThreadList;
                    this.availableThreadList = thread.next;
                    ++this.nActiveThreads;
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var3_2
                    thread.wakeUp(task);
                    return thread;
                }
                try {
                    if (this.nActiveThreads == this.maxThreads) {
                        ++this.deficit;
                        this.wait();
                        continue;
                    }
                    this.availableThreadList = new PooledThread(this);
                    this.availableThreadList.waitCompletion();
                }
                catch (InterruptedException x) {
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Thread thread) throws InterruptedException {
        PooledThread t = (PooledThread)thread;
        t.waitCompletion();
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            t.next = this.availableThreadList;
            this.availableThreadList = t;
            --this.nActiveThreads;
            if (this.deficit > 0) {
                this.notify();
                --this.deficit;
            }
        }
    }

    public synchronized void close() {
        this.closed = true;
        while (this.nActiveThreads > 0) {
            try {
                ++this.deficit;
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        while (this.availableThreadList != null) {
            this.availableThreadList.wakeUp(null);
            this.availableThreadList = this.availableThreadList.next;
        }
    }

    public ThreadPool(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public ThreadPool() {
        this(Integer.MAX_VALUE);
    }

    static class PooledThread
    extends Thread {
        PooledThread next;
        Object ready;
        Object done;
        boolean busy;
        boolean doneNotificationNeeded;
        Runnable task;
        ThreadPool pool;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this.ready;
                synchronized (object) {
                    while (!this.pool.closed) {
                        Object object2 = this.done;
                        synchronized (object2) {
                            this.busy = false;
                            if (this.doneNotificationNeeded) {
                                this.done.notify();
                            }
                        }
                        this.ready.wait();
                        if (this.task == null) break;
                        this.task.run();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void wakeUp(Runnable t) {
            Object object = this.ready;
            synchronized (object) {
                this.busy = true;
                this.doneNotificationNeeded = false;
                this.task = t;
                this.ready.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitCompletion() throws InterruptedException {
            Object object = this.done;
            synchronized (object) {
                if (this.busy) {
                    this.doneNotificationNeeded = true;
                    this.done.wait();
                }
            }
        }

        PooledThread(ThreadPool pool) {
            this.pool = pool;
            this.ready = new Object();
            this.done = new Object();
            this.busy = true;
            this.setDaemon(true);
            this.start();
        }
    }
}

