/*
 * Decompiled with CFR 0.152.
 */
package org.garret.jsql;

import java.lang.reflect.Field;
import org.garret.jsql.L2Elem;
import org.garret.jsql.ListIterator;
import org.garret.jsql.Query;
import org.garret.jsql.TTree;

public class TreeIterator
extends ListIterator {
    protected TTree tree;

    public boolean getByKeyRange(String key, Object minValue, Object maxValue, boolean inclusive, Query result) {
        Field f = this.tree.field;
        if (key.equals(f.getName())) {
            Class<?> type = f.getType();
            this.tree.select(Query.castLiteral(type, minValue), Query.castLiteral(type, maxValue), inclusive, result);
            return true;
        }
        return false;
    }

    public boolean useNormalizedKeys() {
        return false;
    }

    public TreeIterator(Field key) {
        this.tree = new TTree(key);
    }

    public TreeIterator(Class cls, String keyName) throws NoSuchFieldException {
        Field primaryKey = cls.getDeclaredField(keyName);
        primaryKey.setAccessible(true);
        this.tree = new TTree(primaryKey);
    }

    public void add(L2Elem obj) {
        super.add(obj);
        this.tree.add(obj);
    }

    public void remove(L2Elem obj) {
        this.tree.remove(obj);
        obj.unlink();
    }
}

