//-< ArrayIterator.java >--------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      2-Dec-2002  K.A. Knizhnik  * / [] \ *
//                          Last update:  2-Dec-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Query iterator using ArrayList
//-------------------------------------------------------------------*--------*

package org.garret.jsql;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Query iterator using ArrayList
 */
public class ArrayIterator implements QueryIterator, java.io.Serializable { 
    public Object getFirst() {        
        return arr.size() == 0 ? null : arr.get(0);
    }

    public Object getNext(Object prevObj, int prevIndex) {
        return prevIndex+1 < arr.size() ? arr.get(prevIndex+1) : null;
    }

    public Object getByPrimaryKey(String key, Object keyValue) {
        throw new NoIndexException();
    }

    public boolean getByKeyRange(String key, Object minValue, Object maxValue, boolean inclusive, Query result) {
        return false;
    }

    public QueryIterator concurrentIterator() {
        return this;
    }

    public boolean isThreadSafe() { 
        return true;
    }

    public boolean useNormalizedKeys() {
        return true;
    }

    /**
     * Add new element to the list
     * @param obj new element
     */
    public void add(Object obj) { 
        arr.add(obj);
    }

    /**
     * Remove element from the array
     * @param index index of the remove object
     */
    public void remove(int index) { 
        arr.remove(index);
    }

    /**
     * Default constructor for empty array iterator
     */
    public ArrayIterator() {
        arr = new ArrayList();
    }

    /**
     * Constructor of iterator for specified collection
     * @param arr iterated collection
     */
    public ArrayIterator(Collection c) {
        arr = new ArrayList(c);
    }

    protected ArrayList arr;
}


