//-< HashIterator.java >---------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      2-Dec-2002  K.A. Knizhnik  * / [] \ *
//                          Last update:  2-Dec-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Query iterator using hash map for direct access and l2-list for sequential 
// access
//-------------------------------------------------------------------*--------*

package org.garret.jsql;

import java.util.HashMap;

/**
 * Query iterator using hash map for direct access and l2-list for sequential access
 */
public class HashIterator extends ListIterator { 
    public Object getByPrimaryKey(String key, Object keyValue) {
        if (primaryKey.equals(key)) { 
            return map.get(keyValue);
        }
        throw new NoIndexException();
    }

    /**
     * Constructor of hash iterator
     * @param key primary key name
     */
    public HashIterator(String key) { 
        primaryKey = key;
        map = new HashMap();
    }

    /**
     * Add new object
     * @param obj new object
     * @param keyValue value of primary key for this object
     */
    public void add(L2Elem obj, Object keyValue) { 
        super.add(obj);
        map.put(Query.normalizeKeyValue(keyValue), obj);
    }

    /**
     * Remove object with specified key
     * @param keyValue value of the primary key for removed object
     */
    public void remove(Object keyValue) { 
        L2Elem elem = (L2Elem)map.remove(Query.normalizeKeyValue(keyValue));
        if (elem != null) { 
            elem.unlink();
        }
    }

    protected HashMap  map;
    protected String   primaryKey;
}


