//-< HashMapIterator.java >------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      4-Dec-2002  K.A. Knizhnik  * / [] \ *
//                          Last update:  4-Dec-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Query iterator using hash map
//-------------------------------------------------------------------*--------*

package org.garret.jsql;

import java.util.HashMap;
import java.util.Iterator;

/**
 * Query iterator using hash table
 */
public class HashMapIterator implements QueryIterator, Cloneable { 
    public Object getByPrimaryKey(String key, Object keyValue) {
        if (primaryKey.equals(key)) { 
            return map.get(keyValue);
        }
        throw new NoIndexException();
    }

    public Object getFirst() {
        if (iterator == null) { 
            iterator = map.values().iterator();
        }
        return iterator.next();
    }

    public Object getNext(Object prevObj, int prevIndex) {
        return iterator.next();
    }

    public boolean getByKeyRange(String key, Object minValue, Object maxValue, boolean inclusive, Query result) {
        return false;
    }

    public QueryIterator concurrentIterator() {
        try { 
            return (QueryIterator)super.clone();
        } catch (CloneNotSupportedException x) {
            return null;
        }
    }

    public boolean isThreadSafe() { 
	return true;
    }

    public boolean useNormalizedKeys() {
        return true;
    }

    /**
     * Constructor of hash iterator
     * @param key primary key name
     */
    public HashMapIterator(String key) { 
        primaryKey = key;
        map = new HashMap();
    }


    /**
     * Add new object
     * @param obj new object
     * @param keyValue value of primary key for this object
     */
    public void add(Object obj, Object keyValue) { 
        map.put(Query.normalizeKeyValue(keyValue), obj);
    }

    /**
     * Remove object with specified key
     * @param keyValue value of the primary key for removed object
     */
    public void remove(Object keyValue) { 
        map.remove(Query.normalizeKeyValue(keyValue));
    }

    protected HashMap  map;
    protected Iterator iterator;
    protected String   primaryKey;
}


