package org.garret.jsql;

import java.lang.reflect.Field;
import java.util.*;

import org.garret.jsql.ArrayIterator;
import org.garret.jsql.Query;

public class IndexedArrayIterator extends ArrayIterator {
	private final Map indexes = new HashMap();

	/**
	 * Constructor for IndexedArrayIterator.
	 */
	public IndexedArrayIterator() {
		super();
	}

	public void addIndex(String field) {
		indexes.put(field, new HashMap());
	}

	private void addToIndexes(Object obj) {
		Iterator it = indexes.keySet().iterator();
		while (it.hasNext()) {
			String field = (String) it.next();
			Collection keys = getKeys(field, obj);
			Iterator them = keys.iterator();
			while (them.hasNext()) {
				addToIndex(field, them.next(), obj);
			}
		}
	}

	private void addToIndex(String index, Object key, Object value) {
		Map idx = (Map) indexes.get(index);
		key = Query.normalizeKeyValue(key);
		Collection col = (Collection) idx.get(key);
		if (col == null) {
			col = new HashSet();
			idx.put(key, col);
		}
		col.add(value);
	}

	private void removeFromIndexes(Object obj) {
		Iterator it = indexes.keySet().iterator();
		while (it.hasNext()) {
			String field = (String) it.next();
			Collection keys = getKeys(field, obj);
			Iterator them = keys.iterator();
			while (them.hasNext()) {
				removeFromIndex(
					field,
					them.next(),
					obj);
			}
		}
	}

	private void removeFromIndex(String index, Object key, Object value) {
		Map idx = (Map) indexes.get(index);
		key = Query.normalizeKeyValue(key);
		Collection col = (Collection) idx.get(key);
		if (col != null) {
			col.remove(value);
		}
	}

	private Collection getKeys(String field, Object obj) {
		Collection keys = new HashSet();
		Collection roots = new HashSet();

		int dot = field.lastIndexOf('.');
		if (dot > -1) {
			String root = field.substring(0, dot);
			field = field.substring(dot + 1);
			roots.addAll(getKeys(root, obj));
		} else {
			roots.add(obj);
		}

		Iterator it = roots.iterator();
		while (it.hasNext()) {
			Object o = it.next();
			try {
				Field f = o.getClass().getDeclaredField(field);
				f.setAccessible(true);
				Object key = f.get(o);

				if (key instanceof Collection) {
					keys.addAll((Collection) key);
				} else if (key.getClass().isArray()) {
					Object[] a = (Object[]) key;
					for (int i = 0; i < a.length; i++) {
						keys.add(a[i]);
					}
				} else {
					keys.add(key);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		return keys;
	}

	/**
	 * @see org.garret.jsql.ArrayIterator#add(Object)
	 */
	public void add(Object obj) {
		super.add(obj);
		addToIndexes(obj);
	}

	/**
	 * @see org.garret.jsql.QueryIterator#getByKeyRange(String, Object, Object, boolean, Query)
	 */
	public boolean getByKeyRange(
		String key,
		Object minValue,
		Object maxValue,
		boolean inclusive,
		Query result) {
		System.out.println("Requesting index [" + key + "]");
		if (minValue == maxValue) {
			Map idx = (Map) indexes.get(key);
			if (idx != null) {
				Collection col = (Collection) idx.get(minValue);
				if (col != null) {
					Iterator it = col.iterator();
					while (it.hasNext()) {
						result.add(it.next());
					}
				}
				return true;
			}
		}

		return false;
	}

	/**
	 * @see org.garret.jsql.ArrayIterator#remove(int)
	 */
	public void remove(int index) {
		remove(arr.get(index));
	}

	public void remove(Object obj) {
		arr.remove(obj);
		removeFromIndexes(obj);
	}
}
