//-< L2Elem.java >----------------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      2-Dec-2002  K.A. Knizhnik  * / [] \ *
//                          Last update:  2-Dec-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Element of double linked list
//-------------------------------------------------------------------*--------*

package org.garret.jsql;

/**
 * Element of double linked list
 */
public class L2Elem implements java.io.Serializable { 
    protected transient L2Elem next;
    protected transient L2Elem prev;

    /**
     * Get next element
     */
    public final Object getNext() {
        return next;
    }
       
    /**
     * Get previous element
     */
    public final Object getPrevious() {
        return prev;
    }
        

    /**
     * Default constructor
     */
    public L2Elem() { 
	next = prev = this;
    }
    
    /**
     * Unlink element from the list
     */
    public final void unlink() { 
	next.prev = prev;
	prev.next = next;
    }

    /**
     * Link element after specified element in the list
     * @param after element after which this element should be linked into the list
     */
    public final void link(L2Elem after) { 
	next = after.next;
	prev = after;
	after.next = next.prev = this;
    }

    /**
     * Check if list is empty
     * @return <code>false</code> if there are no elements in the list except this one
     */
    public final boolean isEmpty() { 
        return next == prev;
    }
}


