//-< ListIterator.java >---------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      2-Dec-2002  K.A. Knizhnik  * / [] \ *
//                          Last update:  2-Dec-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Query iterator using double linked list
//-------------------------------------------------------------------*--------*

package org.garret.jsql;

/**
 * Query iterator using double linked list
 */
public class ListIterator extends L2Elem implements QueryIterator { 
    public Object getFirst() {
        return isEmpty() ? null : next;
    }

    public Object getNext(Object prevObj, int prevIndex) {
	L2Elem next = ((L2Elem)prevObj).next;
	return (next == this) ? null : next;
    }

    public Object getByPrimaryKey(String key, Object keyValue) {
        throw new NoIndexException();
    }

    public boolean getByKeyRange(String key, Object minValue, Object maxValue, boolean inclusive, Query result) {
        return false;
    }

    public QueryIterator concurrentIterator() {
        return this;
    }

    public boolean isThreadSafe() { 
	return true;
    }

    public boolean useNormalizedKeys() {
        return true;
    }

    /**
     * Add new element to the list
     * @param obj new element
     */
    public void add(L2Elem obj) { 
	obj.link(this);
    }

    /**
     * Reconstitute the L2-list from a stream (i.e., deserialize it).
     */
    private void readObject(final java.io.ObjectInputStream s)
        throws java.io.IOException, ClassNotFoundException 
    {
        L2Elem elem, prev = this;
        while ((elem = (L2Elem)s.readObject()) != null) { 
            prev.next = elem;
            elem.prev = prev;
            prev = elem;
        }
        prev.next = this;
        this.prev = prev;
    }

    /**
     * Save the state of the <tt>T-Tree</tt> instance to a stream (i.e.,
     * serialize it).
     */
    private void writeObject(java.io.ObjectOutputStream s)
        throws java.io.IOException 
    {
        for (L2Elem elem = next; elem != this; elem = elem.next) { 
            s.writeObject(elem);
        }
        s.writeObject(null);
    }
}

