//-< QueryIterator.java >--------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      5-Mar-99    K.A. Knizhnik  * / [] \ *
//                          Last update:  6-Mar-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Abstraction of query iterator
//-------------------------------------------------------------------*--------*

package org.garret.jsql;


/**
 * Interface for query iterator.
 * Query iterator provides sequential or (and) direct access to the records in the table
 */
public interface QueryIterator {
    /**
     * Get first object.
     *
     * @return first object or <code>null</code> if there are no object to 
     *  search.
     */
    public Object getFirst();


    /**
     * Get next object.
     * 
     * @param prevObj reference returned by previous call of 
     *  <code>getNext</code> or <code>getFirst</code>
     * @param prevIndex index of previous object (starting from 0 for first 
     *  object)
     * @return next object or <code>null</code> if there are no more objects
     */
    public Object getNext(Object prevObj, int prevIndex);
    
    /**
     * Try to use index to locate object by unique primary key.
     * 
     * @param primaryKey name of primary key field. This files should be 
     *  unique among all searched object.
     * @param keyValue key value
     * @return object with specified value of primary key or <code>null</code>
     *  if object was not found.
     * @exception NoIndexException if there is no index for this field
     */
    public Object getByPrimaryKey(String primaryKey, Object keyValue) 
    throws NoIndexException;


    /**
     * Try to use index to select objects belonginh to the specified range
     * 
     * @param key name of key field. 
     * @param minValue low bound for key value (if <code>null</code>, then there
     * is no low bound
     * @param maxValue high bound for key value (if <code>null</code>, then there
     * is no high bound
     * @param inclusive whether bounds are inclusive or exclusive
     * @param result query to which records belongin to the specified range should be added using 
     * <code>add</code> method
     * @return <code>true</code> if index is applicable, <code>false</code> otherwise
     */
    public boolean getByKeyRange(String key, Object minValue, Object maxValue, boolean inclusive, Query result);


    /**
     * JSQL is able to perform sequential search in parallel. 
     * To be able to achive it, query iterator should is either reentrant either cloneable.
     * The method <code>concurrentIterator</code> should either return <code>this</code> if iterator is reentrant, 
     * or clone the iterator. This method will be called prior any other access to the iterator by JSQL.
     * @return <code>this</code> if iterator is reentrant or clone of iterator
     */
    public QueryIterator concurrentIterator();


    /**
     * Check if it is possible to use iterator concurrently.
     * JQSl is able to perform sequential search in parallel. 
     * Iterator should be reentrant or supports clone method to be use in multiple concurrent threads.
     * @return <code>true</code> is iterator can be use in parallel search, <code>false</code> otherwise
     */
    public boolean isThreadSafe();

    /**
     * Check if iterator supporting direct access by key stores key values in normalized form
     * (all integer types as Long, all real types as Double, other types as it is).
     * Normalization of key value should be performed using <code>Query.normilizeKeyValue</code> method.<BR>
     * If this method returns <code>false</code> then JSQL will try to convert search literals
     * to the type of the indexed field. But it is possible only if type of the field is known at query
     * compilation time. Otherwise in case of using dynamic binding such covertsion should be performed
     * by iterator itself using <code>Query.castLiteral</code> method.
     * @return <code>true</code> if key values are stored in the index in normalized form
     */
    public boolean useNormalizedKeys();
}







