//-< RecursiveIterator.java >----------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      8-Dec-2002  K.A. Knizhnik  * / [] \ *
//                          Last update:  8-Dec-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Query iterator for recursive traversal of objects using specified set of
// reference fields
//-------------------------------------------------------------------*--------*

package org.garret.jsql;

import java.lang.reflect.*;
import java.util.HashSet;
import java.util.Collection;
import java.util.Iterator;

/**
 * Query iterator for recursive traversal of objects using specified set of
 * reference fields
 */
public class RecursiveIterator implements QueryIterator {
    /**
     * Class specifying reference which will be used for traversal.
     * If <code>cls</code> is not specified, then it will be located by <code>className</code>;
     * If <code>field</code> is not specified, then it will be located by <code>filedName</code> in this class.
     */
    public static class Reference { 
	public Class  cls;
	public String className;
	public Field  field;
	public String fieldName;

        public Reference(Class cls, String fieldName) { 
            this.cls = cls;
            this.fieldName = fieldName;
        }
        
        public Reference(String className, String fieldName) { 
            this.className = className;
            this.fieldName = fieldName;
        }
    }

    /** Recursive iterator constructor
     * @param root root object from which iteration starts
     * @param references list of reference fields descriptors which will be used for iteration.
     */
    public RecursiveIterator(Object root, Reference[] references) { 
	this.root = root;
	this.references = references;
	for (int i = 0; i < references.length; i++) { 
	    Reference r = references[i];
	    try { 
		if (r.cls == null) { 
		    r.cls = Class.forName(r.className);
		}
		if (r.field == null) { 
		    r.field = r.cls.getDeclaredField(r.fieldName);
		    r.field.setAccessible(true);
		}
	    } catch(ClassNotFoundException x) { 
		throw new NoClassDefFoundError(r.className);
	    } catch(NoSuchFieldException x) { 
		throw new NoSuchFieldError(r.fieldName);
	    }
	}
	markedSet = new HashSet();
	stack = new Object[64];
    }

    static class MarkedObject { 
	Object o;
	
	public int hashCode() { 
	    return o.hashCode();
	}

	public boolean equals(Object mo) { 
	    return o == ((MarkedObject)mo).o;
	}
	
	MarkedObject(Object o) { 
	    this.o = o;
	}
    }

    final void push(Object o) { 
	if (sp == stack.length) { 
	    Object[] newStack = new Object[sp*2];
	    System.arraycopy(stack, 0, newStack, 0, sp);
	    stack = newStack;
	}
	stack[sp++] = o;
    }

    final Object pop() { 
	return sp > 0 ? stack[--sp] : null;
    }

    public Object getFirst() {        
	markedSet.clear();
	sp = 0;
	push(root);
	markedSet.add(new MarkedObject(root));
	return getNext(null, 0);
    }
    
    public Object getNext(Object prevObj, int prevIndex) {
	try { 
            Object o = pop();
            if (o != null) { 
		for (int i = 0, n = references.length; i < n; i++) { 
		    if (references[i].cls.isAssignableFrom(o.getClass())) { 
			Object next = references[i].field.get(o);
			if (next != null) { 
                            if (next instanceof Collection) { 
                                Iterator iterator = ((Collection)next).iterator();
                                while ((next = iterator.next()) != null) { 
                                    if (markedSet.add(new MarkedObject(next))) { 
                                        push(next);
                                    }
                                }
                            } else if (next.getClass().isArray()) { 
                                Object[] arr = (Object[])next;
                                for (int j = 0; j < arr.length; j++) { 
                                    if (arr[j] != null && markedSet.add(new MarkedObject(arr[j]))) { 
                                        push(arr[j]);
                                    }
                                }
                            } else if (markedSet.add(new MarkedObject(next))) { 
                                push(next);
                            }
                        }
                    }
                }
            }
            return o;
	} catch(IllegalAccessException x) { 
            x.printStackTrace();
	    throw new IllegalAccessError();
	}
    }

    public Object getByPrimaryKey(String key, Object keyValue) {
        throw new NoIndexException();
    }

    public boolean getByKeyRange(String key, Object minValue, Object maxValue, boolean inclusive, Query result) {
        return false;
    }

    public QueryIterator concurrentIterator() {
        return null;
    }

    public boolean isThreadSafe() { 
	return false;
    }

    public boolean useNormalizedKeys() { 
	return true;
    }

    HashSet     markedSet;
    Object      stack[];
    Object      root;
    Reference[] references;
    int         sp;
}






