//-< ResultSetIterator.java >----------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      8-Dec-2002  K.A. Knizhnik  * / [] \ *
//                          Last update:  8-Dec-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Query iterator for object array result returned by Query.select method
//-------------------------------------------------------------------*--------*

package org.garret.jsql;

/**
 * Query iterator using ArrayList
 */
public class ResultSetIterator implements QueryIterator, java.io.Serializable { 
    public Object getFirst() {        
        return arr.length == 0 ? null : arr[0];
    }

    public Object getNext(Object prevObj, int prevIndex) {
        return prevIndex+1 < arr.length ? arr[prevIndex+1] : null;
    }

    public Object getByPrimaryKey(String key, Object keyValue) {
        throw new NoIndexException();
    }

    public boolean getByKeyRange(String key, Object minValue, Object maxValue, boolean inclusive, Query result) {
        return false;
    }

    public QueryIterator concurrentIterator() {
        return this;
    }

    public boolean isThreadSafe() { 
        return true;
    }

    public boolean useNormalizedKeys() {
        return true;
    }

    /**
     * Constructor of iterator for specified result set
     * @param arr iterated array 
     */
    public ResultSetIterator(Object[] a) {
        arr = a;
    }

    Object arr[];
}

