//-< TreeIterator.java >---------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      2-Dec-2002  K.A. Knizhnik  * / [] \ *
//                          Last update:  2-Dec-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Query iterator using T-Tree
//-------------------------------------------------------------------*--------*

package org.garret.jsql;

import java.lang.reflect.Field;

/**
 * Query iterator using T-Tree
 */
public class TreeIterator extends ListIterator { 
    public boolean getByKeyRange(String key, Object minValue, Object maxValue, boolean inclusive, Query result) {
        Field f = tree.field;
        if (key.equals(f.getName())) { 
            Class type = f.getType();
            tree.select(Query.castLiteral(type, minValue), Query.castLiteral(type, maxValue), inclusive, result);
            return true;
        }
        return false;
    }

    public boolean useNormalizedKeys() {
        return false;
    }

    /**
     * Constructor of tree iterator
     * @param key key field
     */
    public TreeIterator(Field key) { 
        tree = new TTree(key);
    }

    /**
     * Constructor of tree iterator
     * @param cls class of the members
     * @param keyName name of key field
     */
    public TreeIterator(Class cls, String keyName) throws NoSuchFieldException { 
        Field primaryKey = cls.getDeclaredField(keyName);
        primaryKey.setAccessible(true);
        tree = new TTree(primaryKey);
    }

    /**
     * Add new object
     * @param obj new object
     */
    public void add(L2Elem obj) { 
        super.add(obj);
        tree.add(obj);
    }

    /**
     * Remove object from the tree 
     * @param obj removed object
     */
    public void remove(L2Elem obj) { 
        tree.remove(obj);
        obj.unlink();
    }

    protected TTree tree;
}


