//-< Test.java >-----------------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      1-Mar-99    K.A. Knizhnik  * / [] \ *
//                          Last update:  6-Mar-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Test for JSQL
//-------------------------------------------------------------------*--------*


import java.io.*;
import java.util.Date;
import java.util.Hashtable;

import org.garret.jsql.*;

class Contractor extends L2Elem { 
    Contract contracts[];

    void newContract(Contract contract) {
	Contract[] newContracts = new Contract[contracts.length+1];
	System.arraycopy(contracts, 0, newContracts, 0, contracts.length);
	newContracts[contracts.length] = contract;
	contracts = newContracts;
    }

    void cancelContract(Contract contract) {
	Contract[] newContracts = new Contract[contracts.length-1];
	for (int i = contracts.length, j = i-1; --i >= 0;) { 
	    if (contracts[i] != contract) { 
		newContracts[--j] = contracts[i];
	    }
	}
	contracts = newContracts;
    }
    Contractor() { 
	contracts = new Contract[0];
    }
}

class Detail extends Contractor { 
    String   name;
    String   material;
    String   color;
    double   weight;
}

class Supplier extends Contractor { 
    String   company;
    String   location;
    boolean  foreign;
}


class Contract extends L2Elem   { 
    Date     delivery;
    int      quantity;
    long     price;
    Detail   detail;
    Supplier supplier;
}

class Database implements Serializable { 
    ListIterator contracts;
    HashIterator details;
    HashIterator suppliers;
    
    Database() { 
	contracts = new ListIterator();
	details   = new HashIterator("name");
	suppliers = new HashIterator("company");
    }
}



public class Test { 
    static byte[] inputBuffer = new byte[256];

    static String input(String prompt) {
	while (true) { 
	    try { 
		System.out.print(prompt);
		int len = System.in.read(inputBuffer);
		String answer = new String(inputBuffer, 0, len).trim();
		if (answer.length() != 0) {
		    return answer;
		}
	    } catch (IOException x) {}
	}
    }

    static public void main(String[] args) {
	int i, j;
	String name;
	String company;
	String material;
	String address;
	String condition;
	String price;
	String quantity;
	Date   from, till;
	Detail detail;
	Contract contract;
	Supplier supplier;

	String fileName = "test.dbs";
	Database db = null;
	Query q = new Query();
	Detail[] details;
	Contract[] contracts;
	Supplier[] suppliers;

	try { 
	    FileInputStream input = new FileInputStream(fileName);
	    ObjectInputStream in = new ObjectInputStream(input);
	    db = (Database)in.readObject();
	    in.close();
	    input.close();
	} catch(Exception x) {}
	
	if (db == null) { 
	    db = new Database();
	}

	while (true) { 	    
	    System.out.println("\n\n    MENU:");
	    System.out.println("1.  Details shipped by supplier");
	    System.out.println("2.  Suppliers of the detail");
	    System.out.println("3.  Contracts from specified city");
	    System.out.println("4.  Expensive details to be delivered in specified period");
	    System.out.println("5.  Foreign suppliers");
	    System.out.println("6.  Important contracts");
	    System.out.println("7.  Search for detail");
	    System.out.println("8.  Search for supplier");
	    System.out.println("9.  Search for contract");
	    System.out.println("10. New supplier");
	    System.out.println("11. New detail");
	    System.out.println("12. New contract");
	    System.out.println("13. Cancel contract");
	    System.out.println("14. Exit\n\n");

	    i = 0;
	    try { 
		i = Integer.parseInt(input(">> "), 10);
	    } catch(NumberFormatException x) {}
	    switch (i) { 
	      case 1:
		System.out.println("Details shipped by supplier");
		company = input("Supplier company: ");
		details = (Detail[])q.select("Detail", db.details, 
		    "exists i:(contracts[i].supplier.company='"+company+"')");
		
		System.out.println("Detail\tMaterial\tColor\tWeight");
		for (i = 0; i < details.length; i++) { 
		    System.out.println(details[i].name + "\t" +
				       details[i].material + "\t" +
				       details[i].color + "\t" +
				       details[i].weight);
		} 
		break;
	      case 2:
		System.out.println("Suppliers of the detail");
		name = input("Regular expression for detail name: ");
		details = (Detail[])q.select("Detail", db.details, 
					     "name like '"+name+"'");
		System.out.println("Detail\tCompany\tLocation\tPrice");
		for (i = 0; i < details.length; i++) { 
		    for (j = 0; j < details[i].contracts.length; j++) { 
			supplier = details[i].contracts[j].supplier;
			System.out.println(details[i].name + "\t" +  
					   supplier.company + "\t" + 
					   supplier.location + "\t$" + 
					   details[i].contracts[j].price);
		    }
		}
		break;
	      case 3:
		System.out.println("Contracts from specified city");
		address = input("City: ");
		contracts = (Contract[])q.select("Contract", db.contracts, 
			    "supplier.location ='"+address+"'");
		System.out.println("Detail\tCompany\tQuantity");
		for (i = 0; i < contracts.length; i++) { 
		    System.out.println(contracts[i].detail.name + "\t" + 
				       contracts[i].supplier.company + "\t" + 
				       contracts[i].quantity);
		}
		break;
	      case 4:
		System.out.println("Expensive details to be delivered in specified period");
		from = new Date(input("Delivered after (Day Month Year): "));
		till = new Date(input("Delivered before (Day Month Year): "));
		
		price = input("Minimal contract price: ");
		contracts = (Contract[])q.select("Contract", db.contracts, 
						 "delivery.getTime between "
						 +from.getTime() + " and "
						 +till.getTime()+"and price > "
						 +price + "order by price");
		System.out.println("Detail\tDate\tPrice");
		for (i = 0; i < contracts.length; i++) { 
		    System.out.println(contracts[i].detail.name + "\t" + 
				       contracts[i].delivery + "\t" + 
				       contracts[i].price);
		}
		break;
	      case 5:
		System.out.println("Foreign suppliers");
		suppliers = (Supplier[])q.select("Supplier", db.suppliers, 
			    "foreign and length(contracts)>0");
		System.out.println("Company\tLocation");
		for (i = 0; i < suppliers.length; i++) { 
		    System.out.println(suppliers[i].company + "\t" + 
				       suppliers[i].location);
		}
		break;
	      case 6:
		System.out.println("Important contracts");
		price = input("Minimal contract price: ");
		quantity = input("Minimal contract quantity: ");
		contracts = (Contract[])q.select("Contract", db.contracts, 
			    "(price >=" + price + " or quantity >=" + quantity
			    +") and delivery.getYear=99");
		System.out.println("Company\tPrice\tQuantity\tDelivery");
		for (i = 0; i < contracts.length; i++) { 
		    System.out.println(contracts[i].supplier.company + "\t$" + 
				       contracts[i].price + "\t" + 
				       contracts[i].quantity + "\t" + 
				       contracts[i].delivery);
		}
		break;
	      case 7:
		System.out.println("Select details");
		condition = input("Condition: ");
		try { 
		    details = 
			(Detail[])q.select("Detail", db.details, condition);
		} catch(CompileError x) { 
		    System.out.println(x);
		    break;
		}
		System.out.println("Detail\tMaterial\tColor\tWeight");
		for (i = 0; i < details.length; i++) { 
		    System.out.println(details[i].name + "\t" +
				       details[i].material + "\t" +
				       details[i].color + "\t" +
				       details[i].weight);
		} 
		break;
	      case 8:
		System.out.println("Select suppliers");
		condition = input("Condition: ");
		try { 
		    suppliers = (Supplier[])q.select("Supplier", db.suppliers, 
						     condition);
		} catch(CompileError x) { 
		    System.out.println(x);
		    break;
		}
		System.out.println("Company\tLocation");
		for (i = 0; i < suppliers.length; i++) { 
		    System.out.println(suppliers[i].company + "\t" + 
				       suppliers[i].location);
		}
		break;
	      case 9:
		System.out.println("Select contracts");
		condition = input("Condition: ");
		try { 
		    contracts = (Contract[])q.select("Contract", db.contracts, 
						     condition);
		} catch(CompileError x) { 
		    System.out.println(x);
		    break;
		}
		System.out.println("Company\tDetail\tPrice\tQuantity");
		for (i = 0; i < contracts.length; i++) { 
		    System.out.println(contracts[i].supplier.company + "\t" + 
				       contracts[i].detail.name + "\t$" + 
				       contracts[i].price + "\t" + 
				       contracts[i].quantity); 
		}
		break;
	      case 10:
		System.out.println("New supplier");
		supplier = new Supplier();
		supplier.company = input("Company name: ");
		supplier.location = input("Company location: ");
		supplier.foreign =input("Foreign company (y/n): ").equals("y");
		db.suppliers.add(supplier, supplier.company);
		break;
	      case 11:
		System.out.println("New detail");
		detail = new Detail();
		detail.name = input("Detail name: ");
		detail.material = input("Detail material: ");
		try {
		    detail.weight = 
			Double.valueOf(input("Detail weight: ")).doubleValue();
		} catch(NumberFormatException x) { 
		    System.out.println("Bad number format");
		    break;
		}
		detail.color = input("Detail color: ");
		db.details.add(detail, detail.name);
		break;
	      case 12:
		System.out.println("New contract");
		company = input("Supplier company: ");
		suppliers = (Supplier[])q.select("Supplier", db.suppliers, 
						 "company='"+company+"'");
		if (suppliers.length == 0) { 
		    System.out.println("No such supplier");
		    break;
		}
		if (suppliers.length != 1) { 
		    System.out.println("More than one suppliers with this name");
		    break;
		}
		name = input("Detail name: ");
		details = (Detail[])q.select("Detail", db.details,
					     "name like '"+name+"'");
		if (details.length == 0) { 
		    System.out.println("No such detail");
		    break;
		} else if (details.length != 1) { 
		    System.out.println("More than one record match this pattern");
		    break; 
		}
		contract = new Contract();
		contract.supplier = supplier = suppliers[0];
		contract.detail = detail = details[0];
		try { 
		    contract.price =
			Long.parseLong(input("Contract price: "), 10);
		    contract.quantity = 
			Integer.parseInt(input("Contract quantity:  "), 10);
		} catch(NumberFormatException x) { 
		    System.out.println("Bad number format");
		    break;
		}
		contract.delivery = 
		    new Date(input("Delivery date (Day Month Year): "));
		
		detail.newContract(contract);
		supplier.newContract(contract);
		db.contracts.add(contract);
		break;
	      case 13: 
		System.out.println("Cancel contract");
		company = input("Supplier company: ");
		name = input("Detail name pattern: ");
		contracts = (Contract[])q.select("Contract", db.contracts,
			    "supplier.company='"+company
			    +"'and detail.name like'"+name+"'");
		if (contracts.length == 0) {
		    System.out.println("No such contracts");
		    break;
		}
		for (i = 0; i < contracts.length; i++) { 
		    contracts[i].unlink();
		    contracts[i].supplier.cancelContract(contracts[i]);
		    contracts[i].detail.cancelContract(contracts[i]);
		}
		break;
	      case 14:
		if (input("Do you really want to exit (y/n) ? ").equals("y")) {
		    try { 
			FileOutputStream output = 
			    new FileOutputStream(fileName);
			ObjectOutputStream out = 
			    new ObjectOutputStream(output);
			out.writeObject(db);
			out.close();
			output.close();
		    } catch (Exception x) {
			System.out.println("Failed to save database file");
		    }
		    return;
		}
		break;
	      default:
		System.out.println("Please choose menu items 1..14\n");
	    }
	    System.out.println("Press Return to continue...");
	    try { 
		System.in.read(inputBuffer);
	    } catch (IOException x) {}
	}
    }
}
