//-< TestContains.java >---------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     29-Nov-2002  K.A. Knizhnik  * / [] \ *
//                          Last update: 29-Bov-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Test of CONTAINS ... WITH expression GROUP BY ... HAVNIG expression clause
//-------------------------------------------------------------------*--------*

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

import org.garret.jsql.*;

class Instrument implements Serializable {
	public final int code;
	
	public Instrument(int code) {
		this.code = code;
	}
}

class InstrumentRef implements Serializable {
	public final int ref;
	
	public InstrumentRef(int ref) {
		this.ref = ref;
	}
}

class InstrumentResolver implements Resolver {
	
	public Object resolve(Object obj) {
		InstrumentRef iref = (InstrumentRef) obj;
		return new Instrument(iref.ref);
	}

}

class Position implements Serializable {
        String name;
        int    sector;
        double marketValue;
        InstrumentRef instrument;

        public String toString() {
                return name + ": sector=" + sector + " marketValue=" + marketValue;
        }
        /**
         * Returns the marketValue.
         * @return double
         */
        public double getMarketValue() {
                return marketValue;
        }

        /**
         * Returns the name.
         * @return String
         */
        public String getName() {
                return name;
        }

        /**
         * Returns the sector.
         * @return int
         */
        public int getSector() {
                return sector;
        }

        /**
         * Sets the marketValue.
         * @param marketValue The marketValue to set
         */
        public void setMarketValue(double marketValue) {
                this.marketValue = marketValue;
        }

        /**
         * Sets the name.
         * @param name The name to set
         */
        public void setName(String name) {
                this.name = name;
        }

        /**
         * Sets the sector.
         * @param sector The sector to set
         */
        public void setSector(int sector) {
                this.sector = sector;
        }

};

class Portfolio implements Serializable {
        String name;
        double marketValue;
        Collection position;

        public String toString() {
                return name;
        }
        /**
         * Returns the name.
         * @return String
         */
        public String getName() {
                return name;
        }

        /**
         * Returns the position.
         * @return Collection
         */
        public Collection getPosition() {
                return position;
        }

        /**
         * Returns the marketValue.
         * @return double
         */
        public double getMarketValue() {
                return marketValue;
        }

        /**
         * Sets the name.
         * @param name The name to set
         */
        public void setName(String name) {
                this.name = name;
        }

        /**
         * Sets the position.
         * @param position The position to set
         */
        public void setPosition(Collection position) {
                this.position = position;
        }

        /**
         * Sets the marketValue.
         * @param marketValue The marketValue to set
         */
        public void setMarketValue(double marketValue) {
                this.marketValue = marketValue;
        }

};

public class TestContains {
        static byte[] inputBuffer = new byte[256];

        static String input(String prompt) {
                try {
                        System.out.print(prompt);
                        int len = System.in.read(inputBuffer);
                        return new String(inputBuffer, 0, len).trim();
                } catch (IOException x) {
                        return "";
                }
        }

        public static void main(String args[]) {
                String fileName = args.length == 0 ? "test.dbs" : args[1];
                IndexedArrayIterator portfolioTable = null;
/*
                try {
                        ObjectInputStream in =
                                new ObjectInputStream(new FileInputStream(fileName));
                        portfolioTable = (ArrayIterator) in.readObject();
                        in.close();
                } catch (Exception x) {
                }
*/
                if (portfolioTable == null) {
                        System.out.println("Initializing database...");
                        portfolioTable = new IndexedArrayIterator();
                        portfolioTable.addIndex("name");
                        portfolioTable.addIndex("position.sector");
                        for (int i = 1; i <= 10; i++) {
                                Portfolio p = new Portfolio();
                                p.name = "Portfolio-" + i;
                                p.position = new ArrayList(i);
                                for (int j = 0; j < i; j++) {
                                    Position pp = new Position();
                                    pp = new Position();
                                    pp.name = "Position-" + (j + 1);
                                    p.marketValue += pp.marketValue = j + 1;
                                    pp.sector = j % 3;
                                    pp.instrument = new InstrumentRef(j);
                                    p.position.add(pp);
                                }
                                portfolioTable.add(p);
                        }
/*                      
                        try {
                                ObjectOutputStream out =
                                        new ObjectOutputStream(new FileOutputStream(fileName));
                                out.writeObject(portfolioTable);
                                out.close();
                        } catch (IOException x) {
                                System.out.println("Failed to save database file:" + x);
                        }
*/                      
                }
                String condition;
                Query q = new Query();
                q.setResolver(InstrumentRef.class, Instrument.class, new InstrumentResolver());
                while ((condition = input("Search condition: ")) != null) {
                        if (condition.length() == 0) {
                                System.out.println("Exiting...");
                                break;
                        }
                        try {
                                Object[] result =
                                    q.select(Portfolio.class, portfolioTable, condition);
                                for (int i = 0; i < result.length; i++) {
                                    System.out.println(result[i]);
                                }
                                System.out.println(
                                        "------- " + result.length + " records selected");
                        } catch (CompileError err) {
                                err.printStackTrace();
                        }
                }
        }
}
