//-< TestTraverse.java >---------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      8-Dec-2002  K.A. Knizhnik  * / [] \ *
//                          Last update:  8-Dec-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Test of RecursiveTraverse iterator
//-------------------------------------------------------------------*--------*

import org.garret.jsql.*;

class Node { 
    Node childs[];
    Node link;
    String name;
    
    Node(String name, Node node1, Node node2) { 
        this.name = name;
        childs = new Node[2];
        childs[0] = node1;
        childs[1] = node2;
    }
}

public class TestTraverse {
    public static void main(String args[]) {
        Node d = new Node("A", 
                              new Node("A.1",   
                                         new Node("A.1.1", null, null), 
                                         new Node("A.1.2", null, null)),
                              new Node("A.2", null, null));
        d.childs[1].link = d.childs[0].childs[0];
        d.childs[0].childs[0].link = d.childs[1];
        RecursiveIterator.Reference refs[] = new RecursiveIterator.Reference[2];
        refs[0] = new RecursiveIterator.Reference(Node.class, "childs");
        refs[1] = new RecursiveIterator.Reference(Node.class, "link");
        RecursiveIterator iterator = new RecursiveIterator(d, refs);
        Query query = new Query();
        Node[] childs = (Node[])query.select(Node.class, iterator, "order by name");
        for (int i = 0; i < childs.length; i++) { 
            System.out.println(childs[i].name);
        }
    }
}
