//-< TestTtree.java >------------------------------------------------*--------*
// JSQL                       Version 1.04       (c) 1999  GARRET    *     ?  *
// (Java SQL)                                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:      3-Dec-2002  K.A. Knizhnik  * / [] \ *
//                          Last update:  3-Dec-2002  K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Test of T-Tree container
//-------------------------------------------------------------------*--------*

import java.io.*;

import org.garret.jsql.*;

class Record extends L2Elem { 
    long key;

    Record(long value) { key = value; }
}
  
public class TestTtree { 
    static final int nInsertedRecords = 1000000;
    static final int nRecords = 100000;
    static final int maxDuplicates = 256;

    public static void main(String args[]) throws Exception
    {
	String fileName = args.length == 0 ? "testidx.dbs" : args[1];
        TreeIterator table = new TreeIterator(Record.class, "key");

	try { 
	    ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));
            table = (TreeIterator)in.readObject();
            in.close();
        } catch(IOException x) {}
        
        if (table == null) {             
            table = new TreeIterator(Record.class, "key");
        }
	long insKey = 1999;
	long delKey = 1999;
        int r;
        Query q = new Query();
        q.prepare(Record.class, "key=?");
	long start = System.currentTimeMillis();

	for (int i = 0, j = 0, k = 0, n = 0; i < nInsertedRecords;) { 
	    if (n >= nRecords) { 
		delKey = (3141592621L*delKey + 2718281829L) % 1000000007L;
                q.setIntParameter(1, delKey);
                Record[] result = (Record[])q.execute(table);
                r = (int)(delKey % maxDuplicates);
                if (r < 0) { 
                    r = -r; 
                } 
                r += 1;
                if (result.length != r) { 
                    throw new Error("Result length doesn't match");
                }
		n -= r;
                while (--r >= 0) { 
                    if (result[r].key != delKey) { 
                        throw new Error("Result content doesn't match");
                    }
                    table.remove(result[r]);
                }                
	    }		
	    insKey = (3141592621L*insKey + 2718281829L) % 1000000007L;
            r = (int)(insKey % maxDuplicates);
            if (r < 0) { 
                r = -r; 
            } 
            r += 1;
	    n += r;
	    i += r;
	    do { 
		table.add(new Record(insKey));
	    } while (--r != 0);
	    if (i > j) { 
		System.out.print("Insert " + i + " objects...\r");
                System.out.flush();
		j = i + 1000;
	    }
            // Test serialization of T-Tree
            if (i > k) { 
                /*
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(fileName));
                out.writeObject(table);
                out.close();
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));
                table = (TreeIterator)in.readObject();
                in.close();
                */
                k = i + 100000;
            }
	}
        long stop = System.currentTimeMillis();
	System.out.println("Elapsed time for " + nInsertedRecords + " record: " 
                           + (stop- start) + " milliseconds");
        
        
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(fileName));
        out.writeObject(table);
        out.close();
    }
}





