//-< BLOB.CPP >-----------------------------------------------------*--------*
// OODBC                     Version 1.0         (c) 1999  GARRET    *     ?  *
// (Object adapter for OODBC)                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     09-Sep-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 09-Sep-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Binary Large Object Implementation
//-------------------------------------------------------------------*--------*

#include "oodbc.h"

USE_OODBC_NAMESPACE

dbBlob::dbBlob(size_t blobPartSize) 
{
    bufSize = blobPartSize;
    buf = new char[blobPartSize];
}


size_t dbBlob::getData(void*, size_t)
{
    return 0;
}

bool dbBlob::getDataLen(SQLINTEGER&)
{
    return false;
}

bool dbBlob::startDataProcessing()
{
    return false;
}

bool dbBlob::processData(void*, size_t)
{
    return false;
}

void dbBlob::endDataProcessing()
{
}

bool dbBlob::fetchData() 
{
    assert(cursor != NULL);
    len = 0;
    int result = SQLGetData(cursor->hSelectStmt, columnNo, SQL_C_BINARY, 
			    buf, bufSize, &len);
    if (result != SQL_SUCCESS && result != SQL_SUCCESS_WITH_INFO) { 
	if (result != SQL_NO_DATA_FOUND) { 
	    cursor->result = result;
	    cursor->connection->OODBC_FAILURE(SQLGetData, result, 
					      cursor->hSelectStmt);
	} else { 
	    cursor->result = SQL_SUCCESS; 
	    return false;
	}
    }
    cursor->result = result;
    if (len != SQL_NULL_DATA) { 
	if ((size_t)len > bufSize || len == SQL_NO_TOTAL) { 
	    len = bufSize;
	}
    }
    return true;
}

    
void* dbBlob::getCurrentRecordPtr()
{
    return cursor->object;
}

	       
dbBlob::~dbBlob() 
{
    delete[] buf;
}
    

bool dbLongVar::startDataProcessing() 
{
    bufUsed = 0;
    return true;
}

bool dbLongVar::processData(void*, size_t bufSize)
{
    if (totalLength == SQL_NO_DATA_FOUND) { 
	char* newBuf = new char[(bufSize + bufUsed)*2];
	memcpy(newBuf, buf-bufUsed, (bufSize + bufUsed));
	delete[] (buf-bufUsed);
	bufUsed += bufSize;
	buf = newBuf + bufUsed;
	this->bufSize = bufUsed;
    } else if (size_t(totalLength) > bufSize) { 
	assert(bufUsed == 0);
	char* newBuf = new char[totalLength];
	memcpy(newBuf, buf, bufSize);
	delete[] buf;
	bufUsed = bufSize;
	buf = newBuf + bufSize;
	this->bufSize = totalLength - bufSize;
    }
    return true;
}

void dbLongVar::endDataProcessing()
{
    buf -= bufUsed;
    bufSize += bufUsed;
    len += bufUsed;
}

bool dbLongVar::getDataLen(SQLINTEGER& length) 
{ 
    length = len;
    return true;
} 

size_t dbLongVar::getData(void*, size_t)
{
    return len;
}

void dbLongVar::setSize(size_t newSize) 
{ 
    if (newSize > bufSize) { 
	delete[] buf;
	buf = new char[newSize];
	bufSize = newSize;
    }
    len = newSize;
}

void dbLongVar::append(size_t tailSize) 
{
    if (len + tailSize > bufSize) { 
	char* newBuf = new char[len+tailSize];
	memcpy(newBuf, buf, len);
	delete[] buf;
	buf = newBuf;
        bufSize = len + tailSize; 
    } 
    len += tailSize;
}
