//-< CLASS.CPP >-----------------------------------------------------*--------*
// OODBC                     Version 1.0         (c) 1999  GARRET    *     ?  *
// (Object adapter for OODBC)                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     10-Jul-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 14-Jul-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Metaclass information
//-------------------------------------------------------------------*--------*

#include <string.h>
#include "oodbc.h"

USE_OODBC_NAMESPACE

dbTableDescriptor* dbTableDescriptor::chain;

char dbFieldDescriptor::fieldSeparator = '$';

int const dbFieldDescriptor::CtypeMapping[] = { 
    SQL_C_CHAR, 
    SQL_C_BIT, 
    SQL_C_STINYINT,
    SQL_C_STINYINT,
    SQL_C_SSHORT,
    SQL_C_SLONG,
    SQL_C_SLONG,
    SQL_C_UTINYINT,
    SQL_C_USHORT,
    SQL_C_ULONG,
    SQL_C_ULONG,
    SQL_C_FLOAT, 
    SQL_C_DOUBLE,
    SQL_C_DATE,
    SQL_C_TIME,
    SQL_C_TIMESTAMP,
#ifdef SQL_C_NUMERIC
    SQL_C_NUMERIC,
#else
    SQL_C_ULONG,
#endif
    SQL_C_BINARY
}; 
    
int const dbFieldDescriptor::SQLtypeMapping[] = { 
    SQL_VARCHAR, 
    SQL_BIT, 
    SQL_TINYINT,
    SQL_TINYINT,
    SQL_SMALLINT,
    SQL_INTEGER,
    SQL_INTEGER,
    SQL_TINYINT,
    SQL_SMALLINT,
    SQL_INTEGER,
    SQL_INTEGER,
    SQL_FLOAT, 
    SQL_DOUBLE,
    SQL_TIMESTAMP, //SQL_DATE,
    SQL_TIME,
    SQL_TIMESTAMP,
    SQL_NUMERIC,
    SQL_LONGVARBINARY
};     

dbFieldDescriptor::dbFieldDescriptor(char* name) 
{ 
    next = prev = this;
    this->name = name;
    size = 0;
    offs = 0;
    components = NULL;
    primaryKey = false;
}


dbFieldDescriptor::dbFieldDescriptor(char* name, int offs, 
				     int indicatorOffs, int size, 
				     bool primaryKey)
{
    next = prev = this;
    this->name = name;
    this->offs = offs;
    this->size = size;
    this->primaryKey = primaryKey;
    this->indicatorOffs = indicatorOffs;
    components = NULL;
    type = dbFieldDescriptor::tpStructure;
    assert(!primaryKey || indicatorOffs < 0/*primary key can not be NULL*/);
}

dbFieldDescriptor* dbFieldDescriptor::find(const char* name)
{
    dbFieldDescriptor* field = components;
    do { 
	if (strcmp(field->name, name) == 0) { 
	    return field;
	}
    } while ((field = field->next) != components);

    return NULL;
}


dbFieldDescriptor& dbFieldDescriptor::adjustOffsets(long offs)
{
    if (offs != 0) { 
	dbFieldDescriptor* fd = this;
	do { 
	    fd->offs += offs;
	} while ((fd = fd->next) != this);
    }
    return *this;
}



dbTableDescriptor::dbTableDescriptor(char const* name, 
				     dbFieldDescriptor* columnsList)
{
    next = chain;
    chain = this;
    this->name = name;
    columns = columnsList;
    fields = NULL;
    keys = NULL; 
    totalNamesLength = 0;
    nFields = 0;
    calculateFieldsAttributes(columnsList, "", 0, true); 
    assert(nFields != 0);
}


void dbTableDescriptor::calculateFieldsAttributes(dbFieldDescriptor* first,
						  char const*       prefix, 
						  size_t           offs,
						  bool            primaryKey) 
{
    dbFieldDescriptor *field = first;
    do { 
	if (*prefix != '\0') { 
	    char* p = new char[strlen(prefix)+strlen(field->name)+1];
	    sprintf(p, "%s%s", prefix, field->name);
	    field->longName = p;
	} else { 
	    field->longName = strdup(field->name);
	}
	field->offs += offs;
		   
	if (field->type == dbFieldDescriptor::tpStructure) { 
	    char* aggregateName = new char[strlen(field->longName) + 2];
	    sprintf(aggregateName, "%s%c", field->longName,
		    dbFieldDescriptor::fieldSeparator);
	    calculateFieldsAttributes(field->components, 
				      aggregateName,
				      field->offs,
				      primaryKey & field->primaryKey);
	    delete[] aggregateName;
	} else {
	    totalNamesLength += strlen(field->longName);
	    nFields += 1;
	    field->nextField = fields;
	    fields = field;
	    if (primaryKey & field->primaryKey) { 
		field->nextKey = keys;
		keys = field;
	    }
	}
    } while ((field = field->next) != first);
}


dbFieldDescriptor* dbTableDescriptor::find(const char* name)
{
    dbFieldDescriptor* first = columns;
    dbFieldDescriptor* field = first;
    do { 
	if (strcmp(field->name, name) == 0) { 
	    return field;
	}
    } while ((field = field->next) != first);
    return NULL;
}


