//-< CLASS.H >-------------------------------------------------------*--------*
// OODBC                     Version 1.0         (c) 1999  GARRET    *     ?  *
// (Object adapter for OODBC)                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     10-Jul-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 14-Jul-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Metaclass information
//-------------------------------------------------------------------*--------*

#ifndef __OODBC_CLASS_H__
#define __OODBC_CLASS_H__

#include "config.h"

BEGIN_OODBC_NAMESPACE

#define OODBC_KEY_COL(x, column)  \
*OODBC_NS::dbDescribeField(new OODBC_NS::dbFieldDescriptor(column, (char*)&x-(char*)this, -1, \
                                       sizeof(x), true), x)
#define OODBC_KEY(x)  OODBC_KEY_COL(x, #x)

#define OODBC_FIELD_COL(x, column)  \
*OODBC_NS::dbDescribeField(new OODBC_NS::dbFieldDescriptor(column, (char*)&x-(char*)this, -1, \
                                       sizeof(x), false), x)
#define OODBC_FIELD_IND_COL(x, indicator, column)  \
*OODBC_NS::dbDescribeField(new OODBC_NS::dbFieldDescriptor(column, (char*)&x-(char*)this, \
                                       (char*)&indicator-(char*)this, \
                                       sizeof(x), false), x)
#define OODBC_FIELD(x)  OODBC_FIELD_COL(x, #x)


#define OODBC_SUPERCLASS(x) \
    x::dbDescribeComponents(NULL)->adjustOffsets((char*)((x*)this)-(char*)this)

#define OODBC_TYPE_DESCRIPTOR(fields) \
    OODBC_NS::dbFieldDescriptor* dbDescribeComponents(OODBC_NS::dbFieldDescriptor*) { \
	return &fields; \
    } \
    static OODBC_NS::dbTableDescriptor dbDescriptor 

template<class T>
struct dbFieldWithIndicator {
    T   val;
    SQLINTEGER indicator;

    bool isNull() const { return indicator == SQL_NULL_DATA; }
};



class dbFieldDescriptor { 
  public:
    dbFieldDescriptor* next; // next file within scope
    dbFieldDescriptor* prev; // previous field within scope

    dbFieldDescriptor* nextField;
    dbFieldDescriptor* nextKey;

    char*              name;
    char*              longName;
    int                type;
    int                offs;
    int                size;
    int                indicatorOffs;
    int                columnNo;
    bool               primaryKey;
    dbFieldDescriptor* components;

    enum FieldType { 
	tpString,
	tpBool,
	tpChar,
	tpSChar,
	tpSShort,
	tpSInt,
	tpSLong,
	tpUChar,
	tpUShort,
	tpUInt,
	tpULong,
	tpFloat,
	tpDouble,
	tpDate,
	tpTime,
	tpTimestamp,
	tpNumeric,
	tpBlob,
	tpStructure,
	tpQueryText
    };

    static char      fieldSeparator;
    static const int CtypeMapping[];
    static const int SQLtypeMapping[];

    dbFieldDescriptor* find(const char* name);

    dbFieldDescriptor& operator, (dbFieldDescriptor& field) { 
	dbFieldDescriptor* tail = field.prev;
	tail->next = this;
	prev->next = &field;
	field.prev = prev;
	prev = tail;
	return *this;
    }

    dbFieldDescriptor& adjustOffsets(long offs);

    dbFieldDescriptor(char* name, int offs, int idicatorOffs,
		      int size, bool primaryIndex);

    dbFieldDescriptor(char* name);
    ~dbFieldDescriptor() { delete[] longName; }
};


class dbTableDescriptor { 
    friend class dbAnyCursor;
    friend class dbConnection;
  protected:
    dbTableDescriptor* next;
    static dbTableDescriptor* chain;

    char const*        name;
    dbFieldDescriptor* columns; 
    dbFieldDescriptor* fields;
    dbFieldDescriptor* keys;
    int                totalNamesLength;
    int                nFields;

    void calculateFieldsAttributes(dbFieldDescriptor* fieldsList, 
				   char const* prefix, size_t offs,
				   bool primaryKey);

  public:
    dbFieldDescriptor* find(char const* name);

    dbTableDescriptor(char const* name, dbFieldDescriptor* columnsList);
};

class dbBlob;

inline bool dbFieldIsBlob(dbBlob*) { return true; }
inline bool dbFieldIsBlob(void*) { return false; }

template<class T>
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, T& x) 
{ 
    if (dbFieldIsBlob(&x)) { 
	fd->type = dbFieldDescriptor::tpBlob;
    } else { 
	fd->type = dbFieldDescriptor::tpStructure;
	fd->components = x.dbDescribeComponents(fd);
    } 
    return fd;
}

inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  char&) 
{ 
    fd->type = dbFieldDescriptor::tpChar; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  signed char&) 
{ 
    fd->type = dbFieldDescriptor::tpSChar; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  signed short&) 
{ 
    fd->type = dbFieldDescriptor::tpSShort; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  signed int&) 
{ 
    fd->type = dbFieldDescriptor::tpSInt; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  signed long&) 
{ 
    fd->type = dbFieldDescriptor::tpSLong; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  unsigned char&) 
{ 
    fd->type = dbFieldDescriptor::tpUChar; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  unsigned short&) 
{ 
    fd->type = dbFieldDescriptor::tpUShort; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  unsigned int&) 
{ 
    fd->type = dbFieldDescriptor::tpUInt; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  unsigned long&) 
{ 
    fd->type = dbFieldDescriptor::tpULong; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, bool&) 
{ 
    fd->type = dbFieldDescriptor::tpBool; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, float&) 
{ 
    fd->type = dbFieldDescriptor::tpFloat; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, double&) 
{ 
    fd->type = dbFieldDescriptor::tpDouble; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  DATE_STRUCT&) 
{ 
    fd->type = dbFieldDescriptor::tpDate; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  TIME_STRUCT&) 
{ 
    fd->type = dbFieldDescriptor::tpTime; 
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  TIMESTAMP_STRUCT&) 
{ 
    fd->type = dbFieldDescriptor::tpTimestamp; 
    return fd;
}
#ifdef SQL_C_NUMERIC
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  SQL_NUMERIC_STRUCT&) 
{ 
    fd->type = dbFieldDescriptor::tpNumeric; 
    return fd;
}
#endif
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, char*) 
{ 
    fd->type = dbFieldDescriptor::tpString; 
    return fd;
}

template<class T> 
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<T>&) 
{ 
    fd->type = dbFieldDescriptor::tpString; 
    fd->size = offsetof(T, indicator);
    fd->indicatorOffs = fd->offs + offsetof(dbFieldWithIndicator<T>, indicator);
    return fd;
}

inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<char>&) 
{ 
    fd->type = dbFieldDescriptor::tpChar; 
    fd->size = sizeof(char);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<char>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<signed char>&) 
{ 
    fd->type = dbFieldDescriptor::tpSChar; 
    fd->size = sizeof(signed char);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<signed char>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<signed short>&) 
{ 
    fd->type = dbFieldDescriptor::tpSShort; 
    fd->size = sizeof(signed short);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<signed short>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<signed int>&) 
{ 
    fd->type = dbFieldDescriptor::tpSInt; 
    fd->size = sizeof(int);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<signed int>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<signed long>&) 
{ 
    fd->type = dbFieldDescriptor::tpSLong; 
    fd->size = sizeof(long);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<signed long>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<unsigned char>&)
{ 
    fd->type = dbFieldDescriptor::tpUChar; 
    fd->size = sizeof(unsigned char);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<unsigned char>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					 dbFieldWithIndicator<unsigned short>&)
{ 
    fd->type = dbFieldDescriptor::tpUShort; 
    fd->size = sizeof(unsigned short);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<unsigned short>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<unsigned int>&) 
{ 
    fd->type = dbFieldDescriptor::tpUInt; 
    fd->size = sizeof(unsigned int);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<unsigned int>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<unsigned long>&)
{ 
    fd->type = dbFieldDescriptor::tpULong; 
    fd->size = sizeof(unsigned long);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<unsigned long>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<bool>&) 
{ 
    fd->type = dbFieldDescriptor::tpBool; 
    fd->size = sizeof(bool);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<bool>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<float>&) 
{ 
    fd->type = dbFieldDescriptor::tpFloat; 
    fd->size = sizeof(float);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<float>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<double>&) 
{ 
    fd->type = dbFieldDescriptor::tpDouble; 
    fd->size = sizeof(double);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<double>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<DATE_STRUCT>&) 
{ 
    fd->type = dbFieldDescriptor::tpDate; 
    fd->size = sizeof(DATE_STRUCT);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<DATE_STRUCT>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<TIME_STRUCT>&) 
{ 
    fd->type = dbFieldDescriptor::tpTime; 
    fd->size = sizeof(TIME_STRUCT);
    fd->indicatorOffs = 
	fd->offs + offsetof(dbFieldWithIndicator<TIME_STRUCT>, indicator);
    return fd;
}
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<TIMESTAMP_STRUCT>&) 
{ 
    fd->type = dbFieldDescriptor::tpTimestamp; 
    fd->size = sizeof(TIMESTAMP_STRUCT);
    fd->indicatorOffs = fd->offs 
	+ offsetof(dbFieldWithIndicator<TIMESTAMP_STRUCT>, indicator);
    return fd;
}
#ifdef SQL_C_NUMERIC
inline dbFieldDescriptor* dbDescribeField(dbFieldDescriptor* fd, 
					  dbFieldWithIndicator<SQL_NUMERIC_STRUCT>&) 
{ 
    fd->type = dbFieldDescriptor::tpNumeric; 
    fd->size = sizeof(SQL_NUMERIC_STRUCT);
    fd->indicatorOffs = fd->offs 
	+ offsetof(dbFieldWithIndicator<SQL_NUMERIC_STRUCT>, indicator);
    return fd;
}
#endif

#define OODBC_REGISTER_AS(name, table) \
    OODBC_NS::dbTableDescriptor table::dbDescriptor(name, ((table*)0)->dbDescribeComponents(NULL))

#define OODBC_REGISTER(table) OODBC_REGISTER_AS(#table, table)

#ifndef USE_OODBC_MACRO_PREFIX
#define KEY_COL(x, column) OODBC_KEY_COL(x, column)
#define KEY(x) OODBC_KEY(x)
#define FIELD_COL(x, column) OODBC_FIELD_COL(x, column)
#define FIELD_IND_COL(x, indicator, column) OODBC_FIELD_IND_COL(x, indicator, column)
#define FIELD(x) OODBC_FIELD(x)
#define SUPERCLASS(x) OODBC_SUPERCLASS(x)
#define TYPE_DESCRIPTOR(fields) OODBC_TYPE_DESCRIPTOR(fields)
#define REGISTER_AS(name, table) OODBC_REGISTER_AS(name, table)
#define REGISTER(table) OODBC_REGISTER(table)
#endif

END_OODBC_NAMESPACE

#endif



