//-< CONNECT.H >-----------------------------------------------------*--------*
// OODBC                     Version 1.0         (c) 1999  GARRET    *     ?  *
// (Object adapter for OODBC)                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     10-Jul-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 14-Jul-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Encapsulation of ODBC connection
//-------------------------------------------------------------------*--------*

#ifndef __OODBC_CONNECT_H__
#define __OODBC_CONNECT_H__

#include "config.h"

BEGIN_OODBC_NAMESPACE

class dbConnection { 
    friend class dbAnyCursor;
    friend class dbBlob;
  protected:
    void onError(int result, char const* function, char const* file, int line, 
		 HSTMT hstmt);
	    
  public:
    HENV henv; 
    HDBC hdbc; 
    bool opened;

    bool insert(dbTableDescriptor& table, void* object);
    bool remove(dbTableDescriptor& table, void* object);
    bool update(dbTableDescriptor& table, void* object);

    bool execute(const char* sql);
    bool execute(dbQuery& query);

    bool commit();
    
    bool rollback();

    bool open(char const* dataSource, char const* userName, 
	      char const* password);
    bool close();

    virtual void handleError(int result, char const* place, char const* msg);

    dbConnection() { 
	henv = NULL;
	hdbc = NULL;
	opened = false; 
    }
};


template<class T>
bool insert(dbConnection& conn, T& obj) { 
    return conn.insert(T::dbDescriptor, &obj); 
}

template<class T>
bool remove(dbConnection& conn, T& obj) { 
    return conn.remove(T::dbDescriptor, &obj); 
}

template<class T>
bool update(dbConnection& conn, T& obj) { 
    return conn.update(T::dbDescriptor, &obj); 
}

class dbLocalBuf { 
  private:
    char* ptr;
  public:
    dbLocalBuf(size_t size) { 
	ptr = new char[size];
    }
    operator char* () { return ptr; }
    operator SQLCHAR* () { return (SQLCHAR*)ptr; }
    char* operator + (int shift) { return ptr + shift; }
    ~dbLocalBuf() { 
	delete[] ptr;
    }
};

#define OODBC_FAILURE(_func, _result, _hstmt) \
    onError(_result, #_func, __FILE__, __LINE__, _hstmt)

END_OODBC_NAMESPACE

#endif
