//-< CURSOR.CPP >----------------------------------------------------*--------*
// OODBC                     Version 1.0         (c) 1999  GARRET    *     ?  *
// (Object adapter for OODBC)                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     10-Jul-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 14-Jul-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Result set cursor implementation
//-------------------------------------------------------------------*--------*

#include "oodbc.h"

USE_OODBC_NAMESPACE

bool dbAnyCursor::remove()
{
    assert(opened);
    if (!hDeleteStmt) { 
	char stmt[1024];
	char cursorName[64];
	SWORD len;
	result = SQLGetCursorName(hSelectStmt, (SQLCHAR*)&cursorName, 
				  sizeof cursorName, &len);
	if (!ok()) {
	    connection->OODBC_FAILURE(SQLGetCursorName, result, hSelectStmt);
	    return false;
	}
	
	len = sprintf(stmt, "delete from %s where current of %s", 
		      table->name, cursorName);
#if (ODBCVER >= 0x0300)
	result = SQLAllocHandle(SQL_HANDLE_STMT, connection->hdbc, 
				&hDeleteStmt); 
#else
	result = SQLAllocStmt(connection->hdbc, &hDeleteStmt); 
#endif
	if (!ok()) {
	    connection->OODBC_FAILURE(SQLAllocHandle, result, NULL);
	    return false;
	}
	result = SQLPrepare(hDeleteStmt, (SQLCHAR*)stmt, SQL_NTS);
	if (!ok()) { 
	    connection->OODBC_FAILURE(SQLPrepare, result, hDeleteStmt);
	    return false;
	}
    }
    result = SQLExecute(hDeleteStmt);
    if (!ok()) { 
	connection->OODBC_FAILURE(SQLExecute, result, hDeleteStmt);
	return false;
    }
    return true;
}


bool dbAnyCursor::update()
{
    assert(opened);
    if (hUpdateStmt == NULL) { 
	dbLocalBuf stmt(table->totalNamesLength + table->nFields*3 + 256);
	char cursorName[64];
	SWORD len;
	int i;
	result = SQLGetCursorName(hSelectStmt, (SQLCHAR*)&cursorName, 
				  sizeof cursorName, &len);
	if (!ok()) {
	    connection->OODBC_FAILURE(SQLGetCursorName, result, hSelectStmt);
	    return false;
	}
	dbFieldDescriptor* fd = table->fields;
	int pos = sprintf(stmt, "update %s set %s=? ", 
			  table->name, fd->longName);
	while ((fd = fd->nextField) != NULL) { 
	    pos += sprintf(stmt + pos, ",%s=?", fd->longName);
	}
	pos += sprintf(stmt + pos, " where current of %s", cursorName);
#if (ODBCVER >= 0x0300)
	result = SQLAllocHandle(SQL_HANDLE_STMT, connection->hdbc, 
				&hUpdateStmt); 
#else
	result = SQLAllocStmt(connection->hdbc, &hUpdateStmt); 
#endif
	if (!ok()) {
	    connection->OODBC_FAILURE(SQLAllochandle, result, NULL);
	    return false;
	}
	result = SQLPrepare(hUpdateStmt, stmt, SQL_NTS);
	if (!ok()) { 
	    connection->OODBC_FAILURE(SQLPrepare, result, hUpdateStmt);
	    return false;
	}
	for (i = 1, fd = table->fields; fd != NULL; fd = fd->nextField, i++) {
	    if (fd->type == dbFieldDescriptor::tpBlob) { 
		dbBlob* blob = (dbBlob*)(object + fd->offs);
		SQLINTEGER blobLength;
		if (blob->getDataLen(blobLength)) {
		    blob->len = SQL_LEN_DATA_AT_EXEC(blobLength);
		} else { 
		    blob->len = SQL_DATA_AT_EXEC;
		}
		result = SQLBindParameter(hUpdateStmt, i, SQL_PARAM_INPUT,
					  SQL_C_BINARY, SQL_LONGVARBINARY,
					  0, 0, blob, 0, 
					  &blob->len);
	    } else { 
		result = SQLBindParameter(hUpdateStmt, i, SQL_PARAM_INPUT,
			    dbFieldDescriptor::CtypeMapping[fd->type],
			    dbFieldDescriptor::SQLtypeMapping[fd->type],
			    0, 0, object + fd->offs, 0, NULL);
	    }
	    if (!ok()) { 
		connection->OODBC_FAILURE(SQLBindParameter, result, 
					  hUpdateStmt);
		return false;
	    }
	}
    }
    result = SQLExecute(hUpdateStmt);
	    
    while (result == SQL_NEED_DATA) {
	SQLPOINTER pToken;
	result = SQLParamData(hUpdateStmt, &pToken);
	if (result == SQL_NEED_DATA) {
	    dbBlob* blob = (dbBlob*)pToken;
	    size_t len;
	    while ((len = blob->getData(blob->buf, blob->bufSize)) != 0)
	    {
		result = SQLPutData(hUpdateStmt, blob->buf, len);
		if (!ok()) { 
		    connection->OODBC_FAILURE(SQLPutData, result, 
					      hUpdateStmt);
		    return false;
		}
	    }
	    result = SQL_NEED_DATA;
	}
    }
    if (!ok()) { 
	connection->OODBC_FAILURE(SQLExecute, result, hUpdateStmt);
	return false;
    }
    return true;
}


bool dbAnyCursor::fetch() 
{
    assert(opened);
    result = SQLFetch(hSelectStmt);
    if (result != SQL_SUCCESS && result != SQL_SUCCESS_WITH_INFO) { 
	if (result != SQL_NO_DATA_FOUND) { 
	    connection->OODBC_FAILURE(SQLFetch, result, hSelectStmt);
	} 
	return false;
    }
    for (dbBlob* blob = blobs; blob != NULL; blob = blob->next) { 
	if (blob->startDataProcessing()) { 
	    while (true) { 
		blob->totalLength = blob->len = 0;
		result = SQLGetData(hSelectStmt, blob->columnNo, SQL_C_BINARY, 
				    blob->buf, blob->bufSize, &blob->len);
		if (result != SQL_SUCCESS && result != SQL_SUCCESS_WITH_INFO) {
		    if (result != SQL_NO_DATA_FOUND) { 
			connection->OODBC_FAILURE(SQLGetData, result, 
						  hSelectStmt);
			return false;
		    } else {
			blob->endDataProcessing();
			result = SQL_SUCCESS;
			break;
		    }
		}
		if (blob->len == SQL_NULL_DATA) { 
		    blob->endDataProcessing();
		    break;
		}
		blob->totalLength = blob->len;
		if ((size_t)blob->len > blob->bufSize 
		    || blob->len == SQL_NO_TOTAL)
		{ 
		    blob->len = blob->bufSize;
		}
		if (!blob->processData(blob->buf, blob->len)) { 
		    break;
		}
	    }
	}
    }
    return true;
}


bool dbAnyCursor::select(dbQuery& query, dbSelectionType type)
{
    if (opened) { 
	SQLFreeStmt(hSelectStmt, SQL_CLOSE);
	SQLFreeStmt(hSelectStmt, SQL_UNBIND);
	opened = false;
    }
    if (!hSelectStmt) { 
#if (ODBCVER >= 0x0300)
	result = SQLAllocHandle(SQL_HANDLE_STMT, connection->hdbc, 
				&hSelectStmt); 
#else
	result = SQLAllocStmt(connection->hdbc, &hSelectStmt); 
#endif
	if (!ok()) {
	    connection->OODBC_FAILURE(SQLAllocHandle, result, NULL);
	    return false;
	}
	SQLSetStmtOption(hSelectStmt, SQL_CONCURRENCY, SQL_CONCUR_ROWVER);
    }
    dbLocalBuf stmt(table->totalNamesLength + table->nFields + 
		    query.stmtLen + 64);
    int pos = sprintf(stmt, "select ");
    if (type != dbSelectAll) { 
	pos += sprintf(stmt + pos, "distinct ");
    }
    dbFieldDescriptor* fd = table->fields;
    pos += sprintf(stmt + pos, fd->longName);
    while ((fd = fd->nextField) != NULL) { 
	pos += sprintf(stmt + pos, ",%s", fd->longName);
    }
    pos += sprintf(stmt + pos, " from %s ", table->name);
    dbQueryElement* elem = query.elements;
    int i = 1;
    while (elem != NULL) { 
	if (elem->type == dbFieldDescriptor::tpQueryText) { 
	    pos += sprintf(stmt + pos, (char*)elem->ptr);
	} else { 
	    pos += sprintf(stmt + pos, " ? ");
	    result = 
	      SQLBindParameter(hSelectStmt, i++, SQL_PARAM_INPUT,
			       dbFieldDescriptor::CtypeMapping[elem->type],
			       dbFieldDescriptor::SQLtypeMapping[elem->type],
			       0, 0, elem->ptr, 0, NULL);
	    if (!ok()) {
		connection->OODBC_FAILURE(SQLBindParameter, result,
					  hSelectStmt);
		return false;
	    }
	}
	elem = elem->next;
    }
    result = SQLExecDirect(hSelectStmt, stmt, SQL_NTS);
    if (!ok()) {
	connection->OODBC_FAILURE(SQLExecDirect, result, hSelectStmt);
	return false;
    }
    blobs = NULL;
    for (i = 1, fd = table->fields; fd != NULL; fd = fd->nextField, i++) { 
	if (fd->type == dbFieldDescriptor::tpBlob) { 
	    dbBlob* blob = (dbBlob*)(object + fd->offs);
	    blob->cursor = this;
	    blob->columnNo = i;
	    blob->next = blobs;
	    blobs = blob;
	} else { 
	    result = SQLBindCol(hSelectStmt, i, 
				dbFieldDescriptor::CtypeMapping[fd->type],
				object + fd->offs, fd->size, 
				fd->indicatorOffs >= 0 
				? (SQLINTEGER*)(object + fd->indicatorOffs) 
				: (SQLINTEGER*)0);
	    if (!ok()) {
		connection->OODBC_FAILURE(SQLBindCol, result, hSelectStmt);
		return false;
	    }
	}
    }
    opened = true;
    return true;
}

bool dbAnyCursor::queryByExample(dbSelectionType type)
{
    if (opened) { 
	SQLFreeStmt(hSelectStmt, SQL_CLOSE);
	SQLFreeStmt(hSelectStmt, SQL_UNBIND);
	opened = false;
    }
    if (!hSelectStmt) { 
#if (ODBCVER >= 0x0300)
	result = 
	    SQLAllocHandle(SQL_HANDLE_STMT, connection->hdbc, &hSelectStmt); 
#else
	result = 
	    SQLAllocStmt(connection->hdbc, &hSelectStmt); 
#endif
	if (!ok()) {
	    connection->OODBC_FAILURE(SQLAllocHandle, result, hSelectStmt);
	    return false;
	}
    }
    dbLocalBuf stmt(table->totalNamesLength*2 + table->nFields*8 + 64);
    int pos = sprintf(stmt, "select ");
    if (type != dbSelectAll) { 
	pos += sprintf(stmt + pos, "distinct ");
    }
    dbFieldDescriptor* fd = table->fields;
    pos += sprintf(stmt + pos, fd->longName);
    while ((fd = fd->nextField) != NULL) { 
	pos += sprintf(stmt + pos, ",%s", fd->longName);
    }
    pos += sprintf(stmt + pos, " where ");
    int i;
    for (i = 1, fd = table->fields; fd != NULL; fd = fd->nextField) { 
	if ((fd->indicatorOffs >= 0
	     && *(SQLINTEGER*)(object + fd->indicatorOffs) != SQL_NULL_DATA)
	    || (fd->indicatorOffs < 0 
		&& (fd->type != dbFieldDescriptor::tpString
		    || object[fd->offs] != '\0')))
	{
	    if (i != 1) { 
		pos += sprintf(stmt + pos, " and ");
	    }
	    pos += sprintf(stmt + pos, "%s=?", fd->longName);
	    result = 
		SQLBindParameter(hSelectStmt, i++, SQL_PARAM_INPUT,
				 dbFieldDescriptor::CtypeMapping[fd->type],
				 dbFieldDescriptor::SQLtypeMapping[fd->type],
				 0, 0, object + fd->offs, 0, NULL);
	    if (!ok()) {
		connection->OODBC_FAILURE(SQLBindParameter, result, 
					  hSelectStmt);
		return false;
	    }
	}
    }
    result = SQLExecDirect(hSelectStmt, stmt, SQL_NTS);
    if (!ok()) {
	connection->OODBC_FAILURE(SQLExecDirect, result, hSelectStmt);
	return false;
    }
    blobs = NULL;
    for (i = 1, fd = table->fields; fd != NULL; fd = fd->nextField, i++) { 
	if (fd->type == dbFieldDescriptor::tpBlob) { 
	    dbBlob* blob = (dbBlob*)(object + fd->offs);
	    blob->cursor = this;
	    blob->columnNo = i;
	    blob->next = blobs;
	    blobs = blob;
	} else { 
	    result = SQLBindCol(hSelectStmt, i, 
				dbFieldDescriptor::CtypeMapping[fd->type],
				object + fd->offs, fd->size, 
				fd->indicatorOffs >= 0 
				? (SQLINTEGER*)(object + fd->indicatorOffs) 
				: (SQLINTEGER*)0);
	    if (!ok()) {
		connection->OODBC_FAILURE(SQLBindCol, result, hSelectStmt);
		return false;
	    }
	}
    }
    opened = true;
    return true;
}

void dbAnyCursor::close()
{
    if (hSelectStmt) { 
	SQLFreeStmt(hSelectStmt, SQL_DROP);
	hSelectStmt = 0;
    }
    if (hUpdateStmt) { 
	SQLFreeStmt(hUpdateStmt, SQL_DROP);
	hUpdateStmt = 0;
    }
    if (hDeleteStmt) { 
	SQLFreeStmt(hDeleteStmt, SQL_DROP);
	hDeleteStmt = 0;
    }
    opened = false;
}

