//-< CURSOR.CPP >----------------------------------------------------*--------*
// OODBC                     Version 1.0         (c) 1999  GARRET    *     ?  *
// (Object adapter for OODBC)                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     10-Jul-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 14-Jul-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Result set cursor interface
//-------------------------------------------------------------------*--------*

#ifndef __OODBC_CURSOR_H__
#define __OODBC_CURSOR_H__

#include "config.h"

BEGIN_OODBC_NAMESPACE

enum dbSelectionType { 
    dbSelectAll = 0,
    dbSelectDistinct = 1
};


class dbAnyCursor { 
    friend class dbBlob;
  public:
    bool select(dbQuery& query, dbSelectionType type = dbSelectAll);

    bool select(char const* condition = "", 
		dbSelectionType type = dbSelectAll) 
    { 
	dbQuery query(condition);
	return select(query, type);
    } 

    bool queryByExample(dbSelectionType type = dbSelectAll);

    int  getLastResult() const { return result; }

    bool update();

    bool remove();

    bool fetch();

    void close();

    bool ok() { 
	return result == SQL_SUCCESS || result == SQL_SUCCESS_WITH_INFO; 
    }
    
    bool empty() { 
	return result == SQL_NO_DATA_FOUND;
    }

  protected: 
    dbConnection*       connection;
    dbTableDescriptor*  table;
    HSTMT               hSelectStmt;
    HSTMT               hUpdateStmt;
    HSTMT               hDeleteStmt;
    char*               object;
    bool                opened;
    int                 result;
    dbBlob*             blobs;

    dbAnyCursor(dbConnection* con, dbTableDescriptor* tbl, void* obj) {
	hSelectStmt = NULL;
	hUpdateStmt = NULL;
	hDeleteStmt = NULL;
	connection = con;
	object = (char*)obj;
	table = tbl;
    }
    ~dbAnyCursor() { close(); }
};

template<class T>
class dbCursor : public dbAnyCursor { 
  protected:
    T record;
    
  public:
    dbCursor(dbConnection& conn) :dbAnyCursor(&conn, &T::dbDescriptor, &record)
    {}

    T* operator ->() { 
	return &record;
    }
};

END_OODBC_NAMESPACE

#endif

