//-< QUERY.CPP >-----------------------------------------------------*--------*
// OODBC                     Version 1.0         (c) 1999  GARRET    *     ?  *
// (Object adapter for OODBC)                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     10-Jul-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 14-Jul-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Construction of SQL query with parameters
//-------------------------------------------------------------------*--------*

#include "oodbc.h"

USE_OODBC_NAMESPACE

dbQueryExpression& dbQueryExpression::operator = (dbComponent const& comp) 
{ 
    first = NULL; 
    last = &first;
    add(dbFieldDescriptor::tpQueryText, (char*)comp.structure);
    if (comp.field != NULL) { 
	char sep[2];
	sep[0] = dbFieldDescriptor::fieldSeparator;
	sep[1] = '\0';
	add(dbFieldDescriptor::tpQueryText, sep);
	add(dbFieldDescriptor::tpQueryText, (char*)comp.field);
    }
    operand = false;
    return *this;
}

dbQueryExpression& dbQueryExpression::operator=(dbQueryExpression const& expr)
{ 
    first = new dbQueryElement(dbFieldDescriptor::tpQueryText, "(");
    first->next = expr.first;
    last = expr.last;
    *last = new dbQueryElement(dbFieldDescriptor::tpQueryText, ")");
    last = &(*last)->next;
    operand = false;
    return *this;
}
 
dbQueryExpression& dbQueryExpression::operator, (dbQueryExpression const& expr)
{ 
    *last = new dbQueryElement(dbFieldDescriptor::tpQueryText, "(");
    (*last)->next = expr.first;
    last = expr.last;
    *last = new dbQueryElement(dbFieldDescriptor::tpQueryText, ")");
    last = &(*last)->next;
    operand = false;
    return *this;
}

dbQueryExpression& dbQueryExpression::operator, (dbComponent const& comp) 
{ 
    add(dbFieldDescriptor::tpQueryText, (char*)comp.structure);
    if (comp.field != NULL) { 
	char sep[2];
	sep[0] = dbFieldDescriptor::fieldSeparator;
	sep[1] = '\0';
	add(dbFieldDescriptor::tpQueryText, sep);
	add(dbFieldDescriptor::tpQueryText, (char*)comp.field);
    }
    operand = false;
    return *this;
}

dbQuery& dbQuery::add(dbQueryExpression const& expr) 
{ 
    append(dbFieldDescriptor::tpQueryText, "(");
    *nextElement = expr.first;
    nextElement = expr.last;
    append(dbFieldDescriptor::tpQueryText, ")");
    operand = false;
    return *this;
}



dbQuery& dbQuery::reset() 
{ 
    dbQueryElement* elem = elements;
    while (elem != NULL) { 
	dbQueryElement* next = elem->next;
	delete elem;
	elem = next;
    }
    elements = NULL;
    nextElement = &elements;
    operand = false;
    stmtLen = 0;
    return *this;
}

