//-< QUERY.H >-------------------------------------------------------*--------*
// OODBC                     Version 1.0         (c) 1999  GARRET    *     ?  *
// (Object adapter for OODBC)                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     10-Jul-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 14-Jul-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Construction of SQL query with parameters
//-------------------------------------------------------------------*--------*

#ifndef __OODBC_QUERY_H__
#define __OODBC_QUERY_H__

#include <string.h>
#include "config.h"

BEGIN_OODBC_NAMESPACE

class dbQueryElement { 
    friend class dbQuery;
    friend class dbAnyCursor;
    friend class dbConnection;
    friend class dbQueryExpression;
  public:
    dbQueryElement(dbFieldDescriptor::FieldType t, void const* p) {
	type = t;
	ptr  = (void*)p; 	
	next = NULL;
    } 
  private:
    dbQueryElement* next;
    void* ptr;
    dbFieldDescriptor::FieldType type;
};
    
class dbComponent { 
  public:
    char const* structure;
    char const* field; 

    dbComponent(char const* s, char const* f=NULL) : structure(s), field(f) {}
};

class dbQueryExpression { 
    friend class dbQuery;
    dbQueryElement*  first;
    dbQueryElement** last;
    bool             operand;

    dbQueryExpression& add(dbFieldDescriptor::FieldType type, void* ptr) 
    {
	last = &(*last = new dbQueryElement(type, ptr))->next;
	operand = (type == dbFieldDescriptor::tpQueryText);
	return *this;
    }
	
  public:
    dbQueryExpression& operator = (char const* ptr) { 
	first = NULL, last = &first;
	return add(dbFieldDescriptor::tpQueryText, (void*)ptr);
    }
    dbQueryExpression& operator = (dbComponent const& comp);

    dbQueryExpression& operator = (dbQueryExpression const& expr);

    dbQueryExpression& operator, (char& ptr) { 
        return add(dbFieldDescriptor::tpChar, &ptr);
    }
    dbQueryExpression& operator, (signed char& ptr) { 
        return add(dbFieldDescriptor::tpSChar, &ptr);
    }
    dbQueryExpression& operator, (signed short& ptr) { 
        return add(dbFieldDescriptor::tpSShort, &ptr);
    }
    dbQueryExpression& operator, (signed int& ptr) { 
        return add(dbFieldDescriptor::tpSInt, &ptr);
    }
    dbQueryExpression& operator, (signed long& ptr) { 
        return add(dbFieldDescriptor::tpSLong, &ptr);
    }
    dbQueryExpression& operator, (unsigned char& ptr) { 
        return add(dbFieldDescriptor::tpUChar, &ptr);
    }
    dbQueryExpression& operator, (unsigned short& ptr) { 
        return add(dbFieldDescriptor::tpUShort, &ptr);
    }
    dbQueryExpression& operator, (unsigned int& ptr) { 
        return add(dbFieldDescriptor::tpUInt, &ptr);
    }
    dbQueryExpression& operator, (unsigned long& ptr) { 
        return add(dbFieldDescriptor::tpULong, &ptr);
    }
    dbQueryExpression& operator, (float& ptr) { 
        return add(dbFieldDescriptor::tpFloat, &ptr);
    }
    dbQueryExpression& operator, (double& ptr) { 
        return add(dbFieldDescriptor::tpDouble, &ptr);
    }
    dbQueryExpression& operator, (bool& ptr) { 
        return add(dbFieldDescriptor::tpBool, &ptr);
    }
    dbQueryExpression& operator, (DATE_STRUCT& ptr) { 
        return add(dbFieldDescriptor::tpDate, &ptr);
    }
    dbQueryExpression& operator, (TIME_STRUCT& ptr) { 
        return add(dbFieldDescriptor::tpTime, &ptr);
    }
    dbQueryExpression& operator, (TIMESTAMP_STRUCT& ptr) { 
        return add(dbFieldDescriptor::tpTimestamp, &ptr);
    }
#ifdef SQL_C_NUMERIC
    dbQueryExpression& operator, (SQL_NUMERIC_STRUCT& ptr) { 
        return add(dbFieldDescriptor::tpNumeric, &ptr);
    }
#endif
    dbQueryExpression& operator, (char const* ptr) { 
        return add(operand ? dbFieldDescriptor::tpString 
		   : dbFieldDescriptor::tpQueryText, (char*)ptr);
    }
    dbQueryExpression& operator, (dbQueryExpression const& expr);
    dbQueryExpression& operator, (dbComponent const& comp);
};


class dbQuery { 
    friend class dbAnyCursor;
    friend class dbConnection;
  private:
    dbQueryElement*    elements;
    dbQueryElement**   nextElement;
    bool               operand;
    int                stmtLen;

    //
    // Prohibite query copying
    //
    dbQuery(dbQuery const&) {} 
    dbQuery& operator =(dbQuery const&) { return *this; }

  public:
    dbQuery& append(dbFieldDescriptor::FieldType type, void const* ptr)
    { 
	nextElement = &(*nextElement=new dbQueryElement(type,ptr))->next;
	if (type == dbFieldDescriptor::tpQueryText) { 
	    operand = true;
	    stmtLen += strlen((char*)ptr);
	} else { 
	    operand = false;
	    stmtLen += 3; // " ? "
	}
	return *this;
    }

    //
    // Redefined operator = and , make it possible to specify query in the
    // following way:
    //         int x, y;
    //         dbDataTime dt;
    //         dbQuery q; 
    //         dbCursor<record> cursor;
    //         q = "x=",x,"and y=",y,"and",dt == "date";
    //         for (x = 0; x < max_x; x++) { 
    //             for (y = 0; y < max_y; y++) { 
    //                 cursor.select(q);
    //                 ...
    //             }
    //         }

    dbQuery& add(dbQueryExpression const& expr); 

    dbQuery& And(char const* str) { 
	if (elements != NULL) { 
	    append(dbFieldDescriptor::tpQueryText, "and");
	}
	return append(dbFieldDescriptor::tpQueryText, (char*)str);
    }

    dbQuery& Or(char const* str) { 
	if (elements != NULL) { 
	    append(dbFieldDescriptor::tpQueryText, "or");
	}
	return append(dbFieldDescriptor::tpQueryText, (char*)str);
    }

    dbQuery& add(char const* str) { 
	return append(operand ? dbFieldDescriptor::tpString 
		      : dbFieldDescriptor::tpQueryText, (char*)str);
    }
    dbQuery& add(char& value) { 
	return append(dbFieldDescriptor::tpChar, &value);
    }
    dbQuery& add(signed char& value) { 
	return append(dbFieldDescriptor::tpSChar, &value);
    }
    dbQuery& add (signed short& value) { 
	return append(dbFieldDescriptor::tpSShort, &value);
    }
    dbQuery& add (signed int& value) { 
	return append(dbFieldDescriptor::tpSInt, &value);
    }
    dbQuery& add (signed long& value) { 
	return append(dbFieldDescriptor::tpSLong, &value);
    }
    dbQuery& add(unsigned char& value) { 
	return append(dbFieldDescriptor::tpUChar, &value);
    }
    dbQuery& add (unsigned short& value) { 
	return append(dbFieldDescriptor::tpUShort, &value);
    }
    dbQuery& add (unsigned int& value) { 
	return append(dbFieldDescriptor::tpUInt, &value);
    }
    dbQuery& add (unsigned long& value) { 
	return append(dbFieldDescriptor::tpULong, &value);
    }
    dbQuery& add (float& value) { 
	return append(dbFieldDescriptor::tpFloat, &value);
    }
    dbQuery& add(double& value) { 
	return append(dbFieldDescriptor::tpDouble, &value);
    }
    dbQuery& add(bool& value) { 
	return append(dbFieldDescriptor::tpBool, &value);
    }
    dbQuery& add(DATE_STRUCT& value) { 
	return append(dbFieldDescriptor::tpDate, &value);
    }
    dbQuery& add(TIME_STRUCT& value) { 
	return append(dbFieldDescriptor::tpTime, &value);
    }
    dbQuery& add(TIMESTAMP_STRUCT& value) { 
	return append(dbFieldDescriptor::tpTimestamp, &value);
    }
#ifdef SQL_C_NUMERIC
    dbQuery& add(SQL_NUMERIC_STRUCT& value) { 
	return append(dbFieldDescriptor::tpNumeric, &value);
    }
#endif

    dbQuery& operator, (char const* value) { return add(value); }
    dbQuery& operator, (char&  value) { return add(value); }
    dbQuery& operator, (signed char&  value) { return add(value); }
    dbQuery& operator, (signed short&  value) { return add(value); }
    dbQuery& operator, (signed int&  value) { return add(value); }
    dbQuery& operator, (signed long&  value) { return add(value); }
    dbQuery& operator, (unsigned char&  value) { return add(value); }
    dbQuery& operator, (unsigned short&  value) { return add(value); }
    dbQuery& operator, (unsigned int&  value) { return add(value); }
    dbQuery& operator, (unsigned long&  value) { return add(value); }
    dbQuery& operator, (float& value) { return add(value); }
    dbQuery& operator, (double& value) { return add(value); }
    dbQuery& operator, (bool& value) { return add(value); }
    dbQuery& operator, (DATE_STRUCT& value) { return add(value); }
    dbQuery& operator, (TIME_STRUCT& value) { return add(value); }
    dbQuery& operator, (TIMESTAMP_STRUCT& value) { return add(value); }
#ifdef SQL_C_NUMERIC
    dbQuery& operator, (SQL_NUMERIC_STRUCT& value) { return add(value); }
#endif
    dbQuery& operator, (dbQueryExpression const& expr) { return add(expr); }

    dbQuery& operator = (const char* str) { 
	return reset().append(dbFieldDescriptor::tpQueryText, (char*)str);
    }
    dbQuery& operator = (dbQueryExpression const& expr) { 
	return reset().add(expr);
    }

    dbQuery& reset();

    dbQuery() { 
	elements = NULL;
	nextElement = &elements;
	operand = false;
	stmtLen = 0;
    } 
    dbQuery(char const* str) { 
	stmtLen = strlen(str);
	elements = 
	    new dbQueryElement(dbFieldDescriptor::tpQueryText, (char*)str);
	nextElement = &elements->next;
	operand = true;
    } 
    ~dbQuery() { 
	reset();
    }
};

END_OODBC_NAMESPACE

#endif

