//-< TEST.CPP >------------------------------------------------------*--------*
// OODBC                     Version 1.0         (c) 1999  GARRET    *     ?  *
// (Object adapter for OODBC)                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     10-Jul-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 14-Jul-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// OODBC test and example
//-------------------------------------------------------------------*--------*

#include <stdlib.h>
#include "oodbc.h"

USE_OODBC_NAMESPACE

class Activity {
  public:
    int      projectId;  
    float    percentOfTime;
    char     role[50];

    void print() { 
	printf("ProjectId: %d\npercentOfTime: %5.2f, role: %s\n",
	       projectId, percentOfTime, role);
    }

    TYPE_DESCRIPTOR((FIELD(projectId), 
		     FIELD(percentOfTime),
		     FIELD(role)));
};

class Employee {
  public:
    int      code;
    char     name[100];
    int      age;
    DATE_STRUCT hired;
    long     salary;
    Activity project;    

    TYPE_DESCRIPTOR((KEY(code), 
		     FIELD(name),
		     FIELD(age),
		     FIELD(hired),
		     FIELD(salary),
		     FIELD(project)));
    void print() { 
	printf("code: %d\nname: %s\nage: %d\nhired: %d.%02d.%02d\nsalary: %ld\n",
	       code, name, age, hired.year, hired.month, hired.day, salary);
	project.print();
    }	
};


class Programmer : public Employee {
  public: 
    char     language[16];
    int      experience;
    int      managerId;

    void print() { 
	Employee::print();
	printf("language: %s\nexperience: %d\nmanagerId: %d\n",
	       language, experience, managerId);
    }	

    TYPE_DESCRIPTOR((SUPERCLASS(Employee),
		     FIELD(language),
		     FIELD(experience),
		     FIELD(managerId)));
};

REGISTER(Programmer);


class Manager : public Employee { 
  public:
    int      nSubordinates;

    void print() { 
	Employee::print();
	printf("subordinates: %d\n", nSubordinates);
    }	

    TYPE_DESCRIPTOR((SUPERCLASS(Employee),
		     FIELD(nSubordinates)));
};

REGISTER(Manager);



int main() {
    dbConnection connection;
    if (!connection.open("LocalServer", "sa", "")) { 
	fprintf(stderr, "Failed to open database\n");
	return EXIT_FAILURE;
    }
    connection.execute("create table Manager ("
		       "code INTEGER PRIMARY KEY,"
		       "name VARCHAR(100) NOT NULL,"
		       "age INTEGER,"
		       "hired DATETIME,"
		       "salary INTEGER,"
		       "project$projectId INTEGER,"
		       "project$percentOfTime FLOAT,"
		       "project$role CHAR(50),"
		       "nSubordinates INTEGER)");

    connection.execute("create table Programmer ("
		       "code INTEGER PRIMARY KEY,"
		       "name VARCHAR(50) NOT NULL,"
		       "age INTEGER,"
		       "hired DATETIME,"
		       "salary INTEGER,"
		       "project$projectId INTEGER,"
		       "project$percentOfTime FLOAT,"
		       "project$role CHAR(50),"
		       "language CHAR(16),"
		       "experience SMALLINT,"
		       "managerId INTEGER)");
    
    Programmer p;
    Manager m;

    p.code = 100;
    strcpy(p.name, "John Orlando");
    p.age = 34;
    p.hired.year = 1995;
    p.hired.month = 5;
    p.hired.day = 1;
    p.salary = 70000;
    p.project.projectId = 1001;
    p.project.percentOfTime = 0.50;
    strcpy(p.project.role, "Programmer");
    strcpy(p.language, "C++");
    p.experience = 5;
    p.managerId = 200;
    insert(connection, p);
    
    p.code = 101;
    strcpy(p.name, "Pam Harley");
    p.age = 41;
    p.hired.year = 1989;
    p.hired.month = 1;
    p.hired.day = 1;
    p.salary = 80000;
    p.project.projectId = 1001;
    p.project.percentOfTime = 1.00;
    strcpy(p.project.role, "Software engineer");
    strcpy(p.language, "C");
    p.experience = 7;
    p.managerId = 200;
    insert(connection, p);
    
    m.code = 200;
    strcpy(m.name, "Mark Overgaard");
    m.age = 40;
    m.hired.year = 1997;
    m.hired.month = 1;
    m.hired.day = 1;
    m.salary = 100000;
    m.project.projectId = 1001;
    m.project.percentOfTime = 1.00;
    strcpy(m.project.role, "Project leader");
    m.nSubordinates = 2;
    insert(connection, m);

    strcpy(p.language, "Cobol");
    update(connection, p);
    
    dbCursor<Programmer> programmers(connection);
    dbCursor<Manager>    managers(connection);
    dbQuery              q;
    
    printf("PROGRAMMERS:\n");
    programmers.select();
    while (programmers.fetch()) { 
	programmers->print();
	printf("-----------------------\n");
    }

    printf("\nMANAGERS:\n");
    managers.select();
    while (managers.fetch()) { 
	managers->print();
	printf("-----------------------\n\n");
    }
    
    long minSalary, maxSalary;
    int  experience;
    q = "where salary between",minSalary,"and",maxSalary,
	"and experience >=",experience;
    printf("\nSelect programmers\n");
    printf("Specify minimal level of salary:");
    scanf("%ld", &minSalary);
    printf("Specify maximal level of salary:");
    scanf("%ld", &maxSalary);
    printf("Specify experience (in years):");
    scanf("%d", &experience);
    
    programmers.select(q);
    while (programmers.fetch()) { 
	programmers->print();
	printf("-----------------------\n\n");
    }
    
    printf("\nChange salary for programmers on specified language:\n");
    char language[256]; 
    int delta;
    printf("Programming language: ");
    scanf("%s", language);
    printf("Salary delta: ");
    scanf("%d", &delta);
    q="update programmer set salary=salary+",delta,"where language=",language;
    connection.execute(q);
    q="where language=",language,"for update";
    programmers.select(q);
    while (programmers.fetch()) { 
	programmers->print();
	printf("Additional bonus: ");
	scanf("%d", &delta);
	programmers->salary += delta;
	programmers.update();
    }
    remove(connection, m);
    DATE_STRUCT date;
    date.year = 1990;
    date.month = 1;
    date.day = 1;
    // Remove all new employeers
    q = "where hired>=",date,"for update";
    programmers.select(q);
    int n = 0;
    while (programmers.fetch()) { 
	programmers.remove();
	n += 1;
    }
    printf("Unemploy %d old programmers\n", n);

    q = "where hired<=",date,"for update";
    programmers.select(q);
    n = 0;
    while (programmers.fetch()) { 
	programmers.remove();
	n += 1;
    }
    printf("... and %d new programmers\n", n);


    programmers.close();
    managers.close();
    connection.close();
    return EXIT_SUCCESS;
}








