//-< TESTBLOB.CPP >--------------------------------------------------*--------*
// OODBC                     Version 1.0         (c) 1999  GARRET    *     ?  *
// (Object adapter for OODBC)                                        *   /\|  *
//                                                                   *  /  \  *
//                          Created:     08-Sep-99    K.A. Knizhnik  * / [] \ *
//                          Last update: 09-Sep-99    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// OODBC test for binary large object
//-------------------------------------------------------------------*--------*

#include <stdlib.h>
#include <string.h>
#include "oodbc.h"

USE_OODBC_NAMESPACE

class File : public dbBlob { 
  protected: 
    FILE* f; 
  public: 
    bool    open(char const* name);
    void    close();

    virtual size_t getData(void* buf, size_t buf_size);
    virtual bool   startDataProcessing();
    virtual bool   processData(void* buf, size_t bufSize);
    virtual void   endDataProcessing();
};

class Directory { 
  public:
    char name[256];
    File  file;

    TYPE_DESCRIPTOR((FIELD(name), 
		     FIELD(file)));
};

REGISTER(Directory);


bool File::open(char const* name) 
{
    f = fopen(name, "rb");
    return f != NULL;
}


void File::close()
{
    fclose(f);
}

size_t File::getData(void* buf, size_t buf_size) { 
    return fread(buf, 1, buf_size, f);
}
	
bool File::startDataProcessing() { 
    Directory* entry = (Directory*)getCurrentRecordPtr();
    f = fopen(entry->name, "rb");
    if (f != NULL) { 
	// File alread exists - do not overwrite it
	fclose(f);
	return false;
    }
    f = fopen(entry->name, "wb");
    return f != NULL;
} 

bool File::processData(void* buf, size_t bufSize) {
    return fwrite(buf, 1, bufSize, f) == bufSize;
} 

void File::endDataProcessing() { 
    fclose(f);
}


int main() { 
    dbConnection connection;
    if (!connection.open("LocalServer", "sa", "")) { 
	fprintf(stderr, "Failed to open database\n");
	return EXIT_FAILURE;
    }
    connection.execute("create table Directory ("
		       "name VARCHAR(255) PRIMARY KEY,"
		       "file IMAGE)");
    Directory d;
    dbCursor<Directory> dir(connection);
    dbQuery   q;
    char      buf[256];
    char      name[256];
    
    q = "where name=",name;

    printf("Commands: put, get, update, exit\n");
    while (true) { 
	printf("> ");
	fgets(buf, sizeof buf, stdin);
	if (strncmp(buf, "put", 3) == 0) { 
	    if (sscanf(buf+4, "%s", name) != 1) { 
		do { 
		    printf("File name: ");
		} while (sscanf(buf, "%s", name) != 1);
	    } 
	    if (d.file.open(name)) { 
		strcpy(d.name, name);
		insert(connection, d);
		d.file.close();
	    } else { 
		printf("Failed to write file\n");
	    }
	} else if (strncmp(buf, "get", 3) == 0) {  
	    if (sscanf(buf+4, "%s", name) != 1) { 
		do { 
		    printf("File name: ");
		} while (sscanf(buf, "%s", name) != 1);
	    } 
	    dir.select(q);
	    if (dir.fetch()) { 
		printf("File '%s' was extracted\n", dir->name);
	    } else {
		printf("No such file\n");
	    }
	} else if (strncmp(buf, "update", 6) == 0) {  
	    if (sscanf(buf+7, "%s", name) != 1) { 
		do { 
		    printf("File name: ");
		} while (sscanf(buf, "%s", name) != 1);
	    } 
	    dir.select(q);
	    if (dir.fetch()) { 
		sprintf(name, "%s.sav", dir->name);
		FILE* f = fopen(name, "wb");
		if (f != NULL) { 
		    dbBlob* file = &dir->file;
		    while (file->fetchData()) { 
			fwrite(file->getFetchedDataPtr(), 
			       1, file->getFetchedDataSize(), f);
		    }
		    fclose(f);
		}
		if (dir->file.open(dir->name)) { 
		    dir.update();    
		    dir->file.close();
		} else { 
		    printf("No file to update\n");
		}
	    } else {
		printf("No such file\n");
	    }
	} else if (strncmp(buf, "exit", 4) == 0) { 
	    dir.close();
	    connection.close();
	    break;
	} else { 
	    printf("Commands: put, get, update, exit\n");
	}
    }
    return EXIT_SUCCESS;
}








