/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.generators;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import org.teavm.backend.c.generate.CodeWriter;
import org.teavm.backend.c.generators.Generator;
import org.teavm.backend.c.generators.GeneratorContext;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.dependency.ValueDependencyInfo;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.runtime.RuntimeClass;

public class ArrayGenerator
implements Generator {
    private static final int[] primitives = new int[]{1, 2, 3, 4, 5, 6, 7, 0};
    private static final String[] primitiveWrappers = new String[]{"Byte", "Short", "Character", "Integer", "Long", "Float", "Double", "Boolean"};
    private static final ValueType[] primitiveTypes = new ValueType[]{ValueType.BYTE, ValueType.SHORT, ValueType.CHARACTER, ValueType.INTEGER, ValueType.LONG, ValueType.FLOAT, ValueType.DOUBLE, ValueType.BOOLEAN};

    @Override
    public boolean canHandle(MethodReference method) {
        if (!method.getClassName().equals(Array.class.getName())) {
            return false;
        }
        switch (method.getName()) {
            case "getImpl": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void generate(GeneratorContext context, MethodReference method) {
        String array = context.parameterName(1);
        String index = context.parameterName(2);
        String componentTypeField = context.names().forMemberField(new FieldReference(RuntimeClass.class.getName(), "itemType"));
        String flagsField = context.names().forMemberField(new FieldReference(RuntimeClass.class.getName(), "flags"));
        context.writer().println("TeaVM_Class* componentType = (TeaVM_Class*) TEAVM_CLASS_OF(" + array + ")->" + componentTypeField + ";");
        context.writer().println("int32_t flags = componentType->" + flagsField + ";");
        context.writer().println("if (flags & 2) {").indent();
        context.writer().println("switch ((flags >> 2) & 15) {").indent();
        MethodDependencyInfo dependency = context.dependencies().getMethod(new MethodReference(Array.class, "getImpl", Object.class, Integer.TYPE, Object.class));
        ValueDependencyInfo arrayDependency = dependency.getVariable(1);
        HashSet<ValueType> types = new HashSet<ValueType>(Arrays.asList(arrayDependency.getTypes()));
        for (int i = 0; i < primitiveWrappers.length; ++i) {
            ValueType.Array typeName = ValueType.arrayOf(primitiveTypes[i]);
            if (!types.contains(typeName)) continue;
            String wrapper = "java.lang." + primitiveWrappers[i];
            MethodReference methodRef = new MethodReference(wrapper, "valueOf", primitiveTypes[i], ValueType.object(wrapper));
            String type = CodeWriter.strictTypeAsString(primitiveTypes[i]);
            context.writer().println("case " + primitives[i] + ":").indent();
            context.importMethod(methodRef, true);
            context.writer().println("return " + context.names().forMethod(methodRef) + "(TEAVM_ARRAY_AT(" + array + ", " + type + ", " + index + "));");
            context.writer().outdent();
        }
        context.writer().outdent().println("}").outdent().println("}");
        context.writer().println("return TEAVM_ARRAY_AT(" + array + ", void*, " + index + ");");
    }
}

