/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.intrinsic;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.model.MethodReference;

public class PlatformObjectIntrinsic
implements Intrinsic {
    private static final String PLATFORM_OBJECT = "org.teavm.platform.PlatformObject";

    @Override
    public boolean canHandle(MethodReference method) {
        if (!method.getClassName().equals(PLATFORM_OBJECT)) {
            return false;
        }
        return method.getName().equals("getPlatformClass");
    }

    @Override
    public void apply(IntrinsicContext context, InvocationExpr invocation) {
        switch (invocation.getMethod().getName()) {
            case "getPlatformClass": {
                context.writer().print("TEAVM_CLASS_OF(");
                context.emit(invocation.getArguments().get(0));
                context.writer().print(")");
            }
        }
    }
}

