/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.codegen;

import java.util.HashSet;
import java.util.Set;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.backend.javascript.codegen.ScopedName;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class DefaultAliasProvider
implements AliasProvider {
    private final int maxTopLevelNames;
    private final Set<String> knownAliases = new HashSet<String>(200, 0.5f);
    private final ObjectIntMap<String> knowAliasesCounter = new ObjectIntHashMap<String>();
    private final Set<String> knownInstanceAliases = new HashSet<String>(200, 0.5f);
    private final ObjectIntMap<String> knowInstanceAliasesCounter = new ObjectIntHashMap<String>();
    private boolean additionalScopeStarted;

    public DefaultAliasProvider(int maxTopLevelNames) {
        this.maxTopLevelNames = maxTopLevelNames;
    }

    @Override
    public ScopedName getClassAlias(String cls) {
        return this.makeUnique(DefaultAliasProvider.suggestAliasForClass(cls));
    }

    private static String suggestAliasForClass(String cls) {
        StringBuilder alias = new StringBuilder();
        int lastIndex = 0;
        while (true) {
            int index;
            if ((index = cls.indexOf(46, lastIndex)) == -1) {
                if (lastIndex > 0) {
                    alias.append("_");
                }
                break;
            }
            if (index > lastIndex) {
                alias.append(cls.charAt(lastIndex));
            }
            lastIndex = index + 1;
        }
        alias.append(cls.substring(lastIndex));
        for (int i = 1; i < alias.length(); ++i) {
            char c = alias.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            alias.setCharAt(i, '_');
        }
        if (!Character.isJavaIdentifierStart(alias.charAt(0))) {
            alias.setCharAt(0, '_');
        }
        return alias.toString();
    }

    @Override
    public String getMethodAlias(MethodDescriptor method) {
        Object alias = method.getName();
        switch (alias) {
            case "<init>": {
                alias = "$_init_";
                break;
            }
            case "<clinit>": {
                alias = "$_clinit_";
                break;
            }
            default: {
                alias = "$" + (String)alias;
            }
        }
        return this.makeUniqueInstance((String)alias);
    }

    @Override
    public ScopedName getStaticMethodAlias(MethodReference method) {
        String suggested;
        switch (suggested = method.getDescriptor().getName()) {
            case "<init>": {
                suggested = "_init_";
                break;
            }
            case "<clinit>": {
                suggested = "_clinit_";
            }
        }
        return this.makeUnique(DefaultAliasProvider.suggestAliasForClass(method.getClassName()) + "_" + suggested);
    }

    @Override
    public String getFieldAlias(FieldReference field) {
        return this.makeUniqueInstance("$" + field.getFieldName());
    }

    @Override
    public ScopedName getStaticFieldAlias(FieldReference field) {
        return this.makeUnique(DefaultAliasProvider.suggestAliasForClass(field.getClassName()) + "_" + field.getFieldName());
    }

    @Override
    public ScopedName getFunctionAlias(String name) {
        return this.makeUnique(name);
    }

    @Override
    public ScopedName getClassInitAlias(String className) {
        return this.makeUnique(DefaultAliasProvider.suggestAliasForClass(className) + "_$callClinit");
    }

    @Override
    public String getAdditionalScopeName() {
        return this.makeUnique((String)"$rt_java").name;
    }

    @Override
    public void reserveName(String name) {
    }

    private ScopedName makeUnique(String suggested) {
        Object alias;
        int index;
        suggested = this.sanitize(suggested);
        if (!this.additionalScopeStarted && this.knownAliases.size() >= this.maxTopLevelNames) {
            this.additionalScopeStarted = true;
            this.knownAliases.clear();
            this.knowAliasesCounter.clear();
        }
        if ((index = this.knowAliasesCounter.get((String)(alias = suggested))) > 0) {
            alias = suggested + index++;
        }
        while (!this.knownAliases.add((String)alias)) {
            alias = suggested + index++;
        }
        this.knowAliasesCounter.put((String)alias, index);
        return new ScopedName((String)alias, this.additionalScopeStarted);
    }

    private String sanitize(String s) {
        if (s.isEmpty()) {
            return "_";
        }
        boolean changed = false;
        StringBuilder sb = new StringBuilder(s.length());
        char c = s.charAt(0);
        if (DefaultAliasProvider.isIdentifierStart(c)) {
            sb.append(c);
        } else {
            sb.append('_');
            changed = true;
        }
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (DefaultAliasProvider.isIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
            changed = true;
        }
        return changed ? sb.toString() : s;
    }

    private static boolean isIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$';
    }

    private static boolean isIdentifierPart(char c) {
        return DefaultAliasProvider.isIdentifierStart(c) || c >= '0' && c <= '9';
    }

    private String makeUniqueInstance(String alias) {
        alias = this.sanitize(alias);
        Object uniqueAlias = alias;
        int index = this.knowInstanceAliasesCounter.get(alias);
        if (index > 0) {
            uniqueAlias = alias + index++;
        }
        while (!this.knownInstanceAliases.add((String)uniqueAlias)) {
            uniqueAlias = alias + index++;
        }
        this.knowInstanceAliasesCounter.put(alias, index);
        return uniqueAlias;
    }
}

