/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate.gc.methods;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.model.ValueType;

public class WasmGCGenerationUtil {
    private WasmGCClassInfoProvider classInfoProvider;

    public WasmGCGenerationUtil(WasmGCClassInfoProvider classInfoProvider) {
        this.classInfoProvider = classInfoProvider;
    }

    public WasmExpression allocateArrayWithElements(ValueType itemType, Supplier<List<? extends WasmExpression>> data) {
        return this.allocateArray(itemType, arrayType -> {
            WasmArrayNewFixed expr = new WasmArrayNewFixed((WasmArray)arrayType);
            expr.getElements().addAll((Collection)data.get());
            return expr;
        });
    }

    public WasmExpression allocateArray(ValueType itemType, Function<WasmArray, WasmExpression> data) {
        WasmGCClassInfo classInfo = this.classInfoProvider.getClassInfo(ValueType.arrayOf(itemType));
        WasmGCClassInfo classClass = this.classInfoProvider.getClassInfo("java.lang.Class");
        WasmType.CompositeReference wasmArrayType = (WasmType.CompositeReference)classInfo.getStructure().getFields().get(2).getUnpackedType();
        WasmArray wasmArray = (WasmArray)wasmArrayType.composite;
        WasmStructNew structNew = new WasmStructNew(classInfo.getStructure());
        int depth = 1;
        while (itemType instanceof ValueType.Array) {
            itemType = ((ValueType.Array)itemType).getItemType();
        }
        WasmExpression arrayClassRef = new WasmGetGlobal(this.classInfoProvider.getClassInfo(itemType).getPointer());
        for (int i = 0; i < depth; ++i) {
            arrayClassRef = new WasmCall(this.classInfoProvider.getGetArrayClassFunction(), arrayClassRef);
        }
        WasmStructGet arrayVt = new WasmStructGet(classClass.getStructure(), arrayClassRef, this.classInfoProvider.getClassVtFieldOffset());
        structNew.getInitializers().add(arrayVt);
        structNew.getInitializers().add(new WasmNullConstant(WasmType.Reference.EQ));
        structNew.getInitializers().add(data.apply(wasmArray));
        return structNew;
    }
}

