/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics.gc;

import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.gc.PreciseValueType;
import org.teavm.backend.wasm.generate.CachedExpression;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsic;
import org.teavm.backend.wasm.intrinsics.gc.WasmGCIntrinsicContext;
import org.teavm.backend.wasm.model.WasmArray;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmFunctionType;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmStructure;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class SystemArrayCopyIntrinsic
implements WasmGCIntrinsic {
    private WasmFunction defaultFunction;
    private WasmFunction argsCheckFunction;

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        switch (invocation.getMethod().getName()) {
            case "arraycopy": {
                return this.generateArrayCopy(invocation, context);
            }
            case "doArrayCopy": {
                return this.generateDoArrayCopy(invocation, context);
            }
        }
        throw new IllegalArgumentException();
    }

    private WasmExpression generateArrayCopy(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmExpression result = this.tryGenerateSpecialCase(invocation, context);
        if (result == null) {
            this.tryGenerateSpecialCase(invocation, context);
            WasmFunction function = this.getDefaultFunction(context);
            result = new WasmCall(function, context.generate(invocation.getArguments().get(0)), context.generate(invocation.getArguments().get(1)), context.generate(invocation.getArguments().get(2)), context.generate(invocation.getArguments().get(3)), context.generate(invocation.getArguments().get(4)));
        }
        return result;
    }

    private WasmExpression generateDoArrayCopy(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        WasmStructure objStruct = context.classInfoProvider().getClassInfo(Object.class.getName()).getStructure();
        WasmStructure arrayClsStruct = context.classInfoProvider().getArrayVirtualTableStructure();
        WasmBlock block = new WasmBlock(false);
        CachedExpression source = context.exprCache().create(context.generate(invocation.getArguments().get(0)), objStruct.getReference(), invocation.getLocation(), block.getBody());
        WasmExpression sourceCls = new WasmStructGet(objStruct, source.expr(), 0);
        sourceCls = new WasmCast(sourceCls, arrayClsStruct.getNonNullReference());
        CachedExpression sourceClsCached = context.exprCache().create(sourceCls, arrayClsStruct.getNonNullReference(), invocation.getLocation(), block.getBody());
        WasmStructGet copyFunction = new WasmStructGet(arrayClsStruct, sourceClsCached.expr(), context.classInfoProvider().getArrayCopyOffset());
        WasmType.CompositeReference functionTypeRef = (WasmType.CompositeReference)arrayClsStruct.getFields().get(context.classInfoProvider().getArrayCopyOffset()).getUnpackedType();
        WasmFunctionType functionType = (WasmFunctionType)functionTypeRef.composite;
        WasmCallReference call = new WasmCallReference(copyFunction, functionType);
        call.getArguments().add(new WasmStructGet(arrayClsStruct, sourceClsCached.expr(), 0));
        call.getArguments().add(source.expr());
        call.getArguments().add(context.generate(invocation.getArguments().get(1)));
        call.getArguments().add(context.generate(invocation.getArguments().get(2)));
        call.getArguments().add(context.generate(invocation.getArguments().get(3)));
        call.getArguments().add(context.generate(invocation.getArguments().get(4)));
        block.getBody().add(call);
        source.release();
        sourceClsCached.release();
        return block;
    }

    private WasmExpression tryGenerateSpecialCase(InvocationExpr invocation, WasmGCIntrinsicContext context) {
        ValueType targetItemType;
        Expr sourceArray = invocation.getArguments().get(0);
        Expr targetArray = invocation.getArguments().get(2);
        if (sourceArray.getVariableIndex() < 0 || targetArray.getVariableIndex() < 0) {
            return null;
        }
        PreciseValueType sourceType = (PreciseValueType)context.types().typeOf(sourceArray.getVariableIndex());
        if (sourceType == null || !(sourceType.valueType instanceof ValueType.Array)) {
            return null;
        }
        PreciseValueType targetType = (PreciseValueType)context.types().typeOf(targetArray.getVariableIndex());
        if (targetType == null || !(targetType.valueType instanceof ValueType.Array)) {
            return null;
        }
        ValueType sourceItemType = ((ValueType.Array)sourceType.valueType).getItemType();
        if (sourceItemType != (targetItemType = ((ValueType.Array)targetType.valueType).getItemType()) || !context.hierarchy().isSuperType(targetItemType, sourceItemType, false)) {
            return null;
        }
        WasmBlock block = new WasmBlock(false);
        WasmType.CompositeReference wasmTargetArrayType = (WasmType.CompositeReference)context.typeMapper().mapType(ValueType.arrayOf(targetItemType));
        WasmStructure wasmTargetArrayStruct = (WasmStructure)wasmTargetArrayType.composite;
        WasmExpression wasmTargetArrayWrapper = context.generate(invocation.getArguments().get(2));
        WasmType.CompositeReference wasmTargetArrayTypeRef = (WasmType.CompositeReference)wasmTargetArrayStruct.getFields().get(2).getUnpackedType();
        if (context.isAsync()) {
            wasmTargetArrayTypeRef = wasmTargetArrayTypeRef.composite.getReference();
        }
        CachedExpression wasmTargetArray = context.exprCache().create(new WasmStructGet(wasmTargetArrayStruct, wasmTargetArrayWrapper, 2), wasmTargetArrayTypeRef, null, block.getBody());
        CachedExpression wasmTargetIndex = context.exprCache().create(context.generate(invocation.getArguments().get(3)), WasmType.INT32, null, block.getBody());
        WasmType.CompositeReference wasmSourceArrayType = (WasmType.CompositeReference)context.typeMapper().mapType(ValueType.arrayOf(sourceItemType));
        WasmStructure wasmSourceArrayStruct = (WasmStructure)wasmSourceArrayType.composite;
        WasmExpression wasmSourceArrayWrapper = context.generate(invocation.getArguments().get(0));
        WasmType.CompositeReference wasmSourceArrayTypeRef = (WasmType.CompositeReference)wasmSourceArrayStruct.getFields().get(2).getUnpackedType();
        if (context.isAsync()) {
            wasmSourceArrayTypeRef = wasmSourceArrayTypeRef.composite.getReference();
        }
        CachedExpression wasmSourceArray = context.exprCache().create(new WasmStructGet(wasmSourceArrayStruct, wasmSourceArrayWrapper, 2), wasmSourceArrayTypeRef, null, block.getBody());
        CachedExpression wasmSourceIndex = context.exprCache().create(context.generate(invocation.getArguments().get(1)), WasmType.INT32, null, block.getBody());
        CachedExpression wasmSize = context.exprCache().create(context.generate(invocation.getArguments().get(4)), WasmType.INT32, null, block.getBody());
        block.getBody().add(new WasmCall(this.getArgsCheckFunction(context), wasmTargetArray.expr(), wasmTargetIndex.expr(), wasmSourceArray.expr(), wasmSourceIndex.expr(), wasmSize.expr()));
        block.getBody().add(new WasmArrayCopy((WasmArray)wasmTargetArrayTypeRef.composite, wasmTargetArray.expr(), wasmTargetIndex.expr(), (WasmArray)wasmSourceArrayTypeRef.composite, wasmSourceArray.expr(), wasmSourceIndex.expr(), wasmSize.expr()));
        wasmTargetArray.release();
        wasmTargetIndex.release();
        wasmSourceArray.release();
        wasmSourceIndex.release();
        wasmSize.release();
        return block;
    }

    private WasmFunction getArgsCheckFunction(WasmGCIntrinsicContext context) {
        if (this.argsCheckFunction == null) {
            this.argsCheckFunction = this.createArgsCheckFunction(context);
        }
        return this.argsCheckFunction;
    }

    private WasmFunction createArgsCheckFunction(WasmGCIntrinsicContext context) {
        WasmFunction function = new WasmFunction(context.functionTypes().of(null, WasmType.Reference.ARRAY, WasmType.INT32, WasmType.Reference.ARRAY, WasmType.INT32, WasmType.INT32));
        function.setName(context.names().topLevel("teavm@checkArrayCopy"));
        context.module().functions.add(function);
        WasmLocal targetArrayLocal = new WasmLocal(WasmType.Reference.ARRAY, "targetArray");
        WasmLocal targetArrayIndexLocal = new WasmLocal(WasmType.INT32, "targetIndex");
        WasmLocal sourceArrayLocal = new WasmLocal(WasmType.Reference.ARRAY, "sourceArray");
        WasmLocal sourceArrayIndexLocal = new WasmLocal(WasmType.INT32, "sourceIndex");
        WasmLocal countLocal = new WasmLocal(WasmType.INT32, "count");
        function.add(targetArrayLocal);
        function.add(targetArrayIndexLocal);
        function.add(sourceArrayLocal);
        function.add(sourceArrayIndexLocal);
        function.add(countLocal);
        WasmBlock block = new WasmBlock(false);
        WasmIntBinary targetIndexLessThanZero = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(targetArrayIndexLocal), new WasmInt32Constant(0));
        block.getBody().add(new WasmBranch(targetIndexLessThanZero, block));
        WasmIntBinary sourceIndexLessThanZero = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(sourceArrayIndexLocal), new WasmInt32Constant(0));
        block.getBody().add(new WasmBranch(sourceIndexLessThanZero, block));
        WasmIntBinary countPositive = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(countLocal), new WasmInt32Constant(0));
        block.getBody().add(new WasmBranch(countPositive, block));
        WasmArrayLength targetSize = new WasmArrayLength(new WasmGetLocal(targetArrayLocal));
        WasmIntBinary targetIndexLimit = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, targetSize, new WasmGetLocal(countLocal));
        WasmIntBinary targetIndexGreaterThanSize = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GT_SIGNED, new WasmGetLocal(targetArrayIndexLocal), targetIndexLimit);
        block.getBody().add(new WasmBranch(targetIndexGreaterThanSize, block));
        WasmArrayLength sourceSize = new WasmArrayLength(new WasmGetLocal(sourceArrayLocal));
        WasmIntBinary sourceIndexLimit = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, sourceSize, new WasmGetLocal(countLocal));
        WasmIntBinary sourceIndexGreaterThanSize = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GT_SIGNED, new WasmGetLocal(sourceArrayIndexLocal), sourceIndexLimit);
        block.getBody().add(new WasmBranch(sourceIndexGreaterThanSize, block));
        block.getBody().add(new WasmReturn());
        function.getBody().add(block);
        WasmFunction aioobeFunction = context.functions().forStaticMethod(new MethodReference(WasmGCSupport.class, "aiiobe", ArrayIndexOutOfBoundsException.class));
        WasmThrow throwExpr = new WasmThrow(context.exceptionTag());
        throwExpr.getArguments().add(new WasmCall(aioobeFunction));
        function.getBody().add(throwExpr);
        return function;
    }

    private WasmFunction getDefaultFunction(WasmGCIntrinsicContext manager) {
        if (this.defaultFunction == null) {
            this.defaultFunction = manager.functions().forStaticMethod(new MethodReference(System.class, "arrayCopyImpl", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Void.TYPE));
        }
        return this.defaultFunction;
    }
}

