/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import java.util.List;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.expression.WasmArrayCopy;
import org.teavm.backend.wasm.model.expression.WasmArrayGet;
import org.teavm.backend.wasm.model.expression.WasmArrayLength;
import org.teavm.backend.wasm.model.expression.WasmArrayNewDefault;
import org.teavm.backend.wasm.model.expression.WasmArrayNewFixed;
import org.teavm.backend.wasm.model.expression.WasmArraySet;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmCallReference;
import org.teavm.backend.wasm.model.expression.WasmCast;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmCatch;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmCopy;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExternConversion;
import org.teavm.backend.wasm.model.expression.WasmFill;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatUnary;
import org.teavm.backend.wasm.model.expression.WasmFunctionReference;
import org.teavm.backend.wasm.model.expression.WasmGetGlobal;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt31Get;
import org.teavm.backend.wasm.model.expression.WasmInt31Reference;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntUnary;
import org.teavm.backend.wasm.model.expression.WasmIsNull;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmMemoryGrow;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;
import org.teavm.backend.wasm.model.expression.WasmNullConstant;
import org.teavm.backend.wasm.model.expression.WasmPop;
import org.teavm.backend.wasm.model.expression.WasmPush;
import org.teavm.backend.wasm.model.expression.WasmReferencesEqual;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetGlobal;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmStructGet;
import org.teavm.backend.wasm.model.expression.WasmStructNew;
import org.teavm.backend.wasm.model.expression.WasmStructNewDefault;
import org.teavm.backend.wasm.model.expression.WasmStructSet;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmTest;
import org.teavm.backend.wasm.model.expression.WasmThrow;
import org.teavm.backend.wasm.model.expression.WasmTry;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;

public class WasmBaseReplacingExpressionVisitor
implements WasmExpressionVisitor {
    private WasmExpression replacement;

    public void replace(WasmFunction function) {
        this.replaceExpressions(function.getBody());
    }

    protected void replaceCurrent(WasmExpression expression) {
        this.replacement = expression;
    }

    private void replaceExpressions(List<WasmExpression> expressions) {
        for (int i = 0; i < expressions.size(); ++i) {
            expressions.set(i, this.replace(expressions.get(i)));
        }
    }

    @Override
    public void visit(WasmBlock expression) {
        this.replaceExpressions(expression.getBody());
    }

    @Override
    public void visit(WasmBranch expression) {
        expression.setCondition(this.replace(expression.getCondition()));
        expression.setResult(this.replace(expression.getResult()));
    }

    @Override
    public void visit(WasmNullBranch expression) {
        expression.setValue(this.replace(expression.getValue()));
        expression.setResult(this.replace(expression.getResult()));
    }

    @Override
    public void visit(WasmCastBranch expression) {
        expression.setValue(this.replace(expression.getValue()));
        expression.setResult(this.replace(expression.getResult()));
    }

    @Override
    public void visit(WasmBreak expression) {
        expression.setResult(this.replace(expression.getResult()));
    }

    @Override
    public void visit(WasmSwitch expression) {
        expression.setSelector(this.replace(expression.getSelector()));
    }

    @Override
    public void visit(WasmConditional expression) {
        expression.setCondition(this.replace(expression.getCondition()));
        this.replaceExpressions(expression.getThenBlock().getBody());
        this.replaceExpressions(expression.getElseBlock().getBody());
    }

    @Override
    public void visit(WasmReturn expression) {
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmUnreachable expression) {
    }

    @Override
    public void visit(WasmInt32Constant expression) {
    }

    @Override
    public void visit(WasmInt64Constant expression) {
    }

    @Override
    public void visit(WasmFloat32Constant expression) {
    }

    @Override
    public void visit(WasmFloat64Constant expression) {
    }

    @Override
    public void visit(WasmNullConstant expression) {
    }

    @Override
    public void visit(WasmIsNull expression) {
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmGetLocal expression) {
    }

    @Override
    public void visit(WasmSetLocal expression) {
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmGetGlobal expression) {
    }

    @Override
    public void visit(WasmSetGlobal expression) {
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmIntBinary expression) {
        expression.setFirst(this.replace(expression.getFirst()));
        expression.setSecond(this.replace(expression.getSecond()));
    }

    @Override
    public void visit(WasmFloatBinary expression) {
        expression.setFirst(this.replace(expression.getFirst()));
        expression.setSecond(this.replace(expression.getSecond()));
    }

    @Override
    public void visit(WasmIntUnary expression) {
        expression.setOperand(this.replace(expression.getOperand()));
    }

    @Override
    public void visit(WasmFloatUnary expression) {
        expression.setOperand(this.replace(expression.getOperand()));
    }

    @Override
    public void visit(WasmConversion expression) {
        expression.setOperand(this.replace(expression.getOperand()));
    }

    @Override
    public void visit(WasmCall expression) {
        this.replaceExpressions(expression.getArguments());
    }

    @Override
    public void visit(WasmIndirectCall expression) {
        expression.setSelector(this.replace(expression.getSelector()));
        this.replaceExpressions(expression.getArguments());
    }

    @Override
    public void visit(WasmCallReference expression) {
        expression.setFunctionReference(this.replace(expression.getFunctionReference()));
        this.replaceExpressions(expression.getArguments());
    }

    @Override
    public void visit(WasmDrop expression) {
        expression.setOperand(this.replace(expression.getOperand()));
    }

    @Override
    public void visit(WasmLoadInt32 expression) {
        expression.setIndex(this.replace(expression.getIndex()));
    }

    @Override
    public void visit(WasmLoadInt64 expression) {
        expression.setIndex(this.replace(expression.getIndex()));
    }

    @Override
    public void visit(WasmLoadFloat32 expression) {
        expression.setIndex(this.replace(expression.getIndex()));
    }

    @Override
    public void visit(WasmLoadFloat64 expression) {
        expression.setIndex(this.replace(expression.getIndex()));
    }

    @Override
    public void visit(WasmStoreInt32 expression) {
        expression.setIndex(this.replace(expression.getIndex()));
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmStoreInt64 expression) {
        expression.setIndex(this.replace(expression.getIndex()));
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmStoreFloat32 expression) {
        expression.setIndex(this.replace(expression.getIndex()));
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmStoreFloat64 expression) {
        expression.setIndex(this.replace(expression.getIndex()));
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmMemoryGrow expression) {
        expression.setAmount(this.replace(expression.getAmount()));
    }

    @Override
    public void visit(WasmFill expression) {
        expression.setIndex(this.replace(expression.getIndex()));
        expression.setValue(this.replace(expression.getValue()));
        expression.setCount(this.replace(expression.getCount()));
    }

    @Override
    public void visit(WasmCopy expression) {
        expression.setSourceIndex(this.replace(expression.getSourceIndex()));
        expression.setDestinationIndex(this.replace(expression.getDestinationIndex()));
        expression.setCount(this.replace(expression.getCount()));
    }

    @Override
    public void visit(WasmTry expression) {
        this.replaceExpressions(expression.getBody());
        for (WasmCatch catchClause : expression.getCatches()) {
            this.replaceExpressions(catchClause.getBody());
        }
    }

    @Override
    public void visit(WasmThrow expression) {
        this.replaceExpressions(expression.getArguments());
    }

    @Override
    public void visit(WasmReferencesEqual expression) {
        expression.setFirst(this.replace(expression.getFirst()));
        expression.setSecond(this.replace(expression.getSecond()));
    }

    @Override
    public void visit(WasmCast expression) {
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmTest expression) {
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmExternConversion expression) {
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmStructNew expression) {
        this.replaceExpressions(expression.getInitializers());
    }

    @Override
    public void visit(WasmStructNewDefault expression) {
    }

    @Override
    public void visit(WasmStructGet expression) {
        expression.setInstance(this.replace(expression.getInstance()));
    }

    @Override
    public void visit(WasmStructSet expression) {
        expression.setInstance(this.replace(expression.getInstance()));
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmArrayNewDefault expression) {
        expression.setLength(this.replace(expression.getLength()));
    }

    @Override
    public void visit(WasmArrayNewFixed expression) {
        this.replaceExpressions(expression.getElements());
    }

    @Override
    public void visit(WasmArrayGet expression) {
        expression.setInstance(this.replace(expression.getInstance()));
        expression.setIndex(this.replace(expression.getIndex()));
    }

    @Override
    public void visit(WasmArraySet expression) {
        expression.setInstance(this.replace(expression.getInstance()));
        expression.setIndex(this.replace(expression.getIndex()));
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmArrayLength expression) {
        expression.setInstance(this.replace(expression.getInstance()));
    }

    @Override
    public void visit(WasmArrayCopy expression) {
        expression.setSourceArray(this.replace(expression.getSourceArray()));
        expression.setSourceIndex(this.replace(expression.getSourceIndex()));
        expression.setTargetArray(this.replace(expression.getTargetArray()));
        expression.setTargetIndex(this.replace(expression.getTargetIndex()));
        expression.setSize(this.replace(expression.getSize()));
    }

    @Override
    public void visit(WasmFunctionReference expression) {
    }

    @Override
    public void visit(WasmInt31Reference expression) {
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmInt31Get expression) {
        expression.setValue(this.replace(expression.getValue()));
    }

    @Override
    public void visit(WasmPush expression) {
    }

    @Override
    public void visit(WasmPop expression) {
    }

    private WasmExpression replace(WasmExpression expression) {
        if (expression == null) {
            return null;
        }
        this.visitDefault(expression);
        WasmExpression result = this.replacement;
        if (result == null) {
            result = expression;
        } else {
            this.replacement = null;
        }
        return result;
    }

    protected void visitDefault(WasmExpression expression) {
        expression.acceptVisitor(this);
    }
}

