/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.teavm.backend.wasm.model.WasmBlockType;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCastBranch;
import org.teavm.backend.wasm.model.expression.WasmDefaultExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmExpressionVisitor;
import org.teavm.backend.wasm.model.expression.WasmNullBranch;

public class WasmBlock
extends WasmExpression {
    private boolean loop;
    private List<WasmExpression> body = new ArrayList<WasmExpression>();
    private WasmBlockType type;

    public WasmBlock(boolean loop) {
        this.loop = loop;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public List<WasmExpression> getBody() {
        return this.body;
    }

    public WasmBlockType getType() {
        return this.type;
    }

    public void setType(WasmBlockType type) {
        this.type = type;
    }

    public List<? extends WasmType> getResultTypes() {
        if (this.type == null) {
            return Collections.emptyList();
        }
        if (this.type instanceof WasmBlockType.Function) {
            return ((WasmBlockType.Function)this.type).ref.getReturnTypes();
        }
        return List.of(((WasmBlockType.Value)this.type).type);
    }

    @Override
    public void acceptVisitor(WasmExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected boolean isTerminating(Set<WasmBlock> blocks) {
        if (this.loop) {
            return false;
        }
        if (this.body.isEmpty()) {
            return false;
        }
        blocks.add(this);
        boolean result = this.body.get(this.body.size() - 1).isTerminating(blocks);
        if (result) {
            BreakFinder breakFinder = new BreakFinder();
            breakFinder.target = this;
            this.acceptVisitor(breakFinder);
            if (breakFinder.found) {
                result = false;
            }
        }
        blocks.remove(this);
        return result;
    }

    private static class BreakFinder
    extends WasmDefaultExpressionVisitor {
        private WasmBlock target;
        private boolean found;

        private BreakFinder() {
        }

        @Override
        public void visit(WasmBreak expression) {
            if (expression.getTarget() == this.target) {
                this.found = true;
            }
        }

        @Override
        public void visit(WasmBranch expression) {
            if (expression.getTarget() == this.target) {
                this.found = true;
            }
        }

        @Override
        public void visit(WasmNullBranch expression) {
            if (expression.getTarget() == this.target) {
                this.found = true;
            }
        }

        @Override
        public void visit(WasmCastBranch expression) {
            if (expression.getTarget() == this.target) {
                this.found = true;
            }
        }
    }
}

