/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.runtime;

public final class StringInternPool {
    private static Entry[] table = new Entry[16];
    private static int occupiedCells;
    private static int occupiedCellsThreshold;

    private StringInternPool() {
    }

    public static String query(String s) {
        int hash = s.hashCode();
        int index = Integer.remainderUnsigned(hash, table.length);
        Entry entry = table[index];
        while (entry != null) {
            String value;
            if (entry.hash == hash && (value = entry.getValue()).equals(s)) {
                return value;
            }
            entry = entry.next;
        }
        if (table[index] == null) {
            if (++occupiedCells > occupiedCellsThreshold) {
                StringInternPool.rehash();
            }
            if (table[index = Integer.remainderUnsigned(hash, table.length)] == null) {
                ++occupiedCells;
            }
        }
        StringInternPool.table[index] = new Entry(index, hash, table[index], s);
        return s;
    }

    private static void rehash() {
        Entry[] oldTable = table;
        table = new Entry[oldTable.length * 2];
        occupiedCells = 0;
        occupiedCellsThreshold = table.length * 3 / 4;
        Entry[] entryArray = oldTable;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            Entry value;
            Entry entry = value = entryArray[i];
            while (entry != null) {
                int index;
                Entry next = entry.next;
                entry.index = index = Integer.remainderUnsigned(entry.hash, table.length);
                entry.next = table[index];
                if (entry.next == null) {
                    ++occupiedCells;
                }
                StringInternPool.table[index] = entry;
                entry = next;
            }
        }
    }

    static void remove(Entry entry) {
        int index = entry.index;
        Entry previous = null;
        Entry e = table[index];
        while (e != null) {
            if (e == entry) {
                if (previous == null) {
                    StringInternPool.table[index] = e.next;
                    if (e.next != null) break;
                    --occupiedCells;
                    break;
                }
                previous.next = e.next;
                break;
            }
            previous = e;
            e = e.next;
        }
    }

    static {
        occupiedCellsThreshold = table.length * 3 / 4;
    }

    static class Entry {
        int index;
        final int hash;
        Entry next;

        Entry(int index, int hash, Entry next, String str) {
            this.index = index;
            this.hash = hash;
            this.next = next;
            this.setValue(str);
        }

        final native String getValue();

        final native void setValue(String var1);
    }
}

