/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.function.DoubleSupplier;

public class RandomUtils {
    private RandomUtils() {
    }

    public static void checkStreamSize(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkBound(float bound) {
        if (!((double)bound > 0.0) || !(bound < Float.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkBound(double bound) {
        if (!(bound > 0.0) || !(bound < Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkBound(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkBound(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkRange(float origin, float bound) {
        if (!(origin < bound) || !(bound - origin < Float.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkRange(double origin, double bound) {
        if (!(origin < bound) || !(bound - origin < Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkRange(int origin, int bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkRange(long origin, long bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException();
        }
    }

    public static double[] pairGaussian(DoubleSupplier rng) {
        double v2;
        double v1;
        double s;
        while ((s = (v1 = 2.0 * rng.getAsDouble() - 1.0) * v1 + (v2 = 2.0 * rng.getAsDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double m = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        return new double[]{v1 * m, v2 * m};
    }
}

