/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.List;
import org.teavm.dependency.BootstrapMethodSubstitutor;
import org.teavm.dependency.DynamicCallSite;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.DynamicConstant;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodReference;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.emit.PhiEmitter;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.SwitchTableEntry;

public class SwitchBootstrapSubstitutor
implements BootstrapMethodSubstitutor {
    private static final String CONSTANT_BOOTSTRAPS = "java.lang.invoke.ConstantBootstraps";
    private static final String ENUM_DESC = "java.lang.Enum$EnumDesc";

    @Override
    public ValueEmitter substitute(DynamicCallSite callSite, ProgramEmitter pe) {
        ValueType.Object enumType;
        boolean enumSwitch = callSite.getBootstrapMethod().getName().equals("enumSwitch");
        List<RuntimeConstant> labels = callSite.getBootstrapArguments();
        ValueEmitter target = callSite.getArguments().get(0);
        ValueEmitter restartIdx = callSite.getArguments().get(1);
        BasicBlock joint = pe.prepareBlock();
        PhiEmitter result = pe.phi(ValueType.INTEGER, joint);
        pe.when(() -> target.isNull()).thenDo(() -> {
            pe.constant(-1).propagateTo(result);
            pe.jump(joint);
        });
        SwitchInstruction switchInsn = new SwitchInstruction();
        switchInsn.setCondition(restartIdx.getVariable());
        pe.addInstruction(switchInsn);
        BasicBlock block = pe.prepareBlock();
        pe.enter(block);
        ValueType.Object object = enumType = enumSwitch ? (ValueType.Object)callSite.getCalledMethod().parameterType(0) : null;
        if (enumType != null) {
            pe.initClass(enumType.getClassName());
        }
        for (int i = 0; i < labels.size(); ++i) {
            SwitchTableEntry entry = new SwitchTableEntry();
            entry.setCondition(i);
            entry.setTarget(block);
            switchInsn.getEntries().add(entry);
            RuntimeConstant label = labels.get(i);
            block = pe.prepareBlock();
            if (this.emitFragment(target, i, label, pe, result, joint, enumType, callSite.getAgent().getDiagnostics(), callSite.getLocation(), callSite.getCaller())) {
                pe.jump(block);
            }
            pe.enter(block);
        }
        switchInsn.setDefaultTarget(block);
        pe.constant(callSite.getBootstrapArguments().size()).propagateTo(result);
        pe.jump(joint);
        pe.enter(joint);
        return result.getValue();
    }

    private boolean emitFragment(ValueEmitter target, int idx, RuntimeConstant label, ProgramEmitter pe, PhiEmitter result, BasicBlock exit, ValueType.Object enumType, Diagnostics diagnostics, TextLocation location, MethodReference caller) {
        switch (label.getKind()) {
            case 5: {
                ValueType type = label.getValueType();
                this.emitTypeFragment(target, idx, type, pe, result, exit);
                break;
            }
            case 0: {
                int val = label.getInt();
                pe.when(() -> target.instanceOf(ValueType.object("java.lang.Number")).isTrue().and(() -> target.cast(Number.class).invokeVirtual("intValue", Integer.TYPE, new ValueEmitter[0]).isEqualTo(pe.constant(val)))).thenDo(() -> {
                    pe.constant(idx).propagateTo(result);
                    pe.jump(exit);
                });
                pe.when(() -> target.instanceOf(ValueType.object("java.lang.Character")).isTrue().and(() -> target.cast(Character.class).invokeSpecial("charValue", Character.TYPE, new ValueEmitter[0]).isEqualTo(pe.constant(val)))).thenDo(() -> {
                    pe.constant(idx).propagateTo(result);
                    pe.jump(exit);
                });
                break;
            }
            case 4: {
                String str = label.getString();
                pe.when(enumType != null ? () -> pe.getField(enumType.getClassName(), str, enumType).isSame(target) : () -> pe.constant(str).invokeVirtual("equals", Boolean.TYPE, target.cast(Object.class)).isTrue()).thenDo(() -> {
                    pe.constant(idx).propagateTo(result);
                    pe.jump(exit);
                });
                break;
            }
            case 8: {
                return this.handleDynamicConstant(target, idx, label.getDynamicConstant(), pe, result, exit, diagnostics, new CallLocation(caller, location));
            }
            default: {
                throw new IllegalArgumentException("Unsupported constant type: " + label.getKind());
            }
        }
        return true;
    }

    private boolean handleDynamicConstant(ValueEmitter target, int idx, DynamicConstant cst, ProgramEmitter pe, PhiEmitter result, BasicBlock exit, Diagnostics diagnostics, CallLocation location) {
        MethodHandle bsm = cst.bootstrapMethod;
        if (bsm.getClassName().equals(CONSTANT_BOOTSTRAPS)) {
            switch (bsm.getName()) {
                case "primitiveClass": {
                    pe.constant(idx).propagateTo(result);
                    pe.jump(exit);
                    return false;
                }
                case "invoke": {
                    this.handleInvokeConstant(target, idx, cst, pe, result, exit, diagnostics, location);
                    return true;
                }
            }
        }
        MethodReference bsmRef = new MethodReference(bsm.getClassName(), bsm.getName(), bsm.signature());
        diagnostics.error(location, "Unsupported dynamic constant: {{m0}}", bsmRef);
        return false;
    }

    private void handleInvokeConstant(ValueEmitter target, int idx, DynamicConstant cst, ProgramEmitter pe, PhiEmitter result, BasicBlock exit, Diagnostics diagnostics, CallLocation location) {
        if (cst.type.isObject(ENUM_DESC)) {
            List<? extends RuntimeConstant> enumArgs = cst.bootstrapMethodArguments;
            List<? extends RuntimeConstant> classArgs = enumArgs.get((int)1).getDynamicConstant().bootstrapMethodArguments;
            String enumClassName = classArgs.get(1).getString();
            String enumConstantName = enumArgs.get(2).getString();
            ValueType.Object enumType = ValueType.object(enumClassName);
            pe.initClass(enumClassName);
            pe.when(() -> pe.getField(enumClassName, enumConstantName, enumType).isSame(target)).thenDo(() -> {
                pe.constant(idx).propagateTo(result);
                pe.jump(exit);
            });
        } else {
            diagnostics.error(location, "Unsupported invoke constant type: {{t0}}", cst.type);
        }
    }

    private void emitTypeFragment(ValueEmitter target, int idx, ValueType type, ProgramEmitter pe, PhiEmitter result, BasicBlock exit) {
        pe.when(() -> target.instanceOf(type).isTrue()).thenDo(() -> {
            pe.constant(idx).propagateTo(result);
            pe.jump(exit);
        });
    }
}

