/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.string;

import java.util.List;
import org.teavm.model.AccessLevel;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;

public class DefaultStringTransformer
implements ClassHolderTransformer {
    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (cls.getName().equals("java.lang.String")) {
            this.transformString(cls);
        }
    }

    private void transformString(ClassHolder cls) {
        List<FieldHolder> fields = List.copyOf(cls.getFields());
        for (FieldHolder field : fields) {
            cls.removeField(field);
        }
        FieldHolder charactersField = new FieldHolder("characters");
        charactersField.setType(ValueType.arrayOf(ValueType.CHARACTER));
        charactersField.setLevel(AccessLevel.PRIVATE);
        cls.addField(charactersField);
        for (FieldHolder field : fields) {
            cls.addField(field);
        }
        for (MethodHolder method : cls.getMethods()) {
            if (method.getProgram() == null) continue;
            this.transformProgram(method.getProgram());
        }
    }

    private void transformProgram(Program program) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                InvokeInstruction invoke;
                if (!(instruction instanceof InvokeInstruction) || !(invoke = (InvokeInstruction)instruction).getMethod().getClassName().equals("java.lang.String")) continue;
                switch (invoke.getMethod().getName()) {
                    case "initWithEmptyChars": {
                        this.replaceInitWithEmptyChars(invoke);
                        break;
                    }
                    case "borrowChars": {
                        this.replaceBorrowChars(invoke);
                        break;
                    }
                    case "initWithCharArray": {
                        this.replaceInitWithCharArray(invoke);
                        break;
                    }
                    case "takeCharArray": {
                        this.replaceTakeCharArray(invoke);
                        break;
                    }
                    case "charactersLength": {
                        this.replaceCharactersLength(invoke);
                        break;
                    }
                    case "charactersGet": {
                        this.replaceCharactersGet(invoke);
                        break;
                    }
                    case "copyCharsToArray": {
                        this.replaceCopyCharsToArray(invoke);
                        break;
                    }
                    case "fastCharArray": {
                        this.replaceFastCharArray(invoke);
                    }
                }
            }
        }
    }

    private void replaceInitWithEmptyChars(InvokeInstruction invoke) {
        Program program = invoke.getProgram();
        GetFieldInstruction getField = new GetFieldInstruction();
        getField.setField(new FieldReference("java.lang.String", "EMPTY_CHARS"));
        getField.setFieldType(ValueType.arrayOf(ValueType.CHARACTER));
        getField.setReceiver(program.createVariable());
        getField.setLocation(invoke.getLocation());
        invoke.insertNext(getField);
        PutFieldInstruction putField = new PutFieldInstruction();
        putField.setField(new FieldReference("java.lang.String", "characters"));
        putField.setFieldType(ValueType.arrayOf(ValueType.CHARACTER));
        putField.setInstance(invoke.getInstance());
        putField.setValue(getField.getReceiver());
        putField.setLocation(invoke.getLocation());
        getField.insertNext(putField);
        invoke.delete();
    }

    private void replaceBorrowChars(InvokeInstruction invoke) {
        Program program = invoke.getProgram();
        GetFieldInstruction getField = new GetFieldInstruction();
        getField.setField(new FieldReference("java.lang.String", "characters"));
        getField.setFieldType(ValueType.arrayOf(ValueType.CHARACTER));
        getField.setInstance(invoke.getArguments().get(0));
        getField.setReceiver(program.createVariable());
        getField.setLocation(invoke.getLocation());
        invoke.insertNext(getField);
        PutFieldInstruction putField = new PutFieldInstruction();
        putField.setField(new FieldReference("java.lang.String", "characters"));
        putField.setFieldType(ValueType.arrayOf(ValueType.CHARACTER));
        putField.setInstance(invoke.getInstance());
        putField.setValue(getField.getReceiver());
        putField.setLocation(invoke.getLocation());
        getField.insertNext(putField);
        invoke.delete();
    }

    private void replaceInitWithCharArray(InvokeInstruction invoke) {
        Program program = invoke.getProgram();
        ConstructArrayInstruction createArray = new ConstructArrayInstruction();
        createArray.setItemType(ValueType.CHARACTER);
        createArray.setSize(invoke.getArguments().get(2));
        createArray.setReceiver(program.createVariable());
        createArray.setLocation(invoke.getLocation());
        invoke.insertNext(createArray);
        IntegerConstantInstruction zero = new IntegerConstantInstruction();
        zero.setReceiver(program.createVariable());
        zero.setLocation(invoke.getLocation());
        createArray.insertNext(zero);
        InvokeInstruction arrayCopy = new InvokeInstruction();
        arrayCopy.setType(InvocationType.SPECIAL);
        arrayCopy.setMethod(new MethodReference(System.class, "arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Void.TYPE));
        arrayCopy.setArguments(invoke.getArguments().get(0), invoke.getArguments().get(1), createArray.getReceiver(), zero.getReceiver(), invoke.getArguments().get(2));
        zero.insertNext(arrayCopy);
        PutFieldInstruction putField = new PutFieldInstruction();
        putField.setField(new FieldReference("java.lang.String", "characters"));
        putField.setFieldType(ValueType.arrayOf(ValueType.CHARACTER));
        putField.setInstance(program.variableAt(0));
        putField.setValue(createArray.getReceiver());
        putField.setLocation(invoke.getLocation());
        arrayCopy.insertNext(putField);
        invoke.delete();
    }

    private void replaceTakeCharArray(InvokeInstruction invoke) {
        PutFieldInstruction putField = new PutFieldInstruction();
        putField.setField(new FieldReference("java.lang.String", "characters"));
        putField.setFieldType(ValueType.arrayOf(ValueType.CHARACTER));
        putField.setInstance(invoke.getInstance());
        putField.setValue(invoke.getArguments().get(0));
        putField.setLocation(invoke.getLocation());
        invoke.replace(putField);
    }

    private void replaceCharactersLength(InvokeInstruction invoke) {
        Program program = invoke.getProgram();
        GetFieldInstruction getField = new GetFieldInstruction();
        getField.setField(new FieldReference("java.lang.String", "characters"));
        getField.setFieldType(ValueType.arrayOf(ValueType.CHARACTER));
        getField.setInstance(invoke.getInstance());
        getField.setReceiver(program.createVariable());
        getField.setLocation(invoke.getLocation());
        invoke.insertNext(getField);
        UnwrapArrayInstruction unwrapArray = new UnwrapArrayInstruction(ArrayElementType.CHAR);
        unwrapArray.setArray(getField.getReceiver());
        unwrapArray.setReceiver(program.createVariable());
        unwrapArray.setLocation(invoke.getLocation());
        getField.insertNext(unwrapArray);
        ArrayLengthInstruction getLength = new ArrayLengthInstruction();
        getLength.setArray(unwrapArray.getReceiver());
        getLength.setReceiver(invoke.getReceiver());
        getLength.setLocation(invoke.getLocation());
        unwrapArray.insertNext(getLength);
        invoke.delete();
    }

    private void replaceCharactersGet(InvokeInstruction invoke) {
        Program program = invoke.getProgram();
        GetFieldInstruction getField = new GetFieldInstruction();
        getField.setField(new FieldReference("java.lang.String", "characters"));
        getField.setFieldType(ValueType.arrayOf(ValueType.CHARACTER));
        getField.setInstance(invoke.getInstance());
        getField.setReceiver(program.createVariable());
        getField.setLocation(invoke.getLocation());
        invoke.insertNext(getField);
        UnwrapArrayInstruction unwrapArray = new UnwrapArrayInstruction(ArrayElementType.CHAR);
        unwrapArray.setArray(getField.getReceiver());
        unwrapArray.setReceiver(program.createVariable());
        unwrapArray.setLocation(invoke.getLocation());
        getField.insertNext(unwrapArray);
        GetElementInstruction getFromArray = new GetElementInstruction(ArrayElementType.CHAR);
        getFromArray.setArray(unwrapArray.getReceiver());
        getFromArray.setReceiver(invoke.getReceiver());
        getFromArray.setIndex(invoke.getArguments().get(0));
        getFromArray.setLocation(invoke.getLocation());
        unwrapArray.insertNext(getFromArray);
        invoke.delete();
    }

    private void replaceCopyCharsToArray(InvokeInstruction invoke) {
        Program program = invoke.getProgram();
        GetFieldInstruction getField = new GetFieldInstruction();
        getField.setField(new FieldReference("java.lang.String", "characters"));
        getField.setFieldType(ValueType.arrayOf(ValueType.CHARACTER));
        getField.setInstance(invoke.getInstance());
        getField.setReceiver(program.createVariable());
        getField.setLocation(invoke.getLocation());
        invoke.insertNext(getField);
        InvokeInstruction arrayCopy = new InvokeInstruction();
        arrayCopy.setType(InvocationType.SPECIAL);
        arrayCopy.setMethod(new MethodReference(System.class, "arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Void.TYPE));
        arrayCopy.setArguments(getField.getReceiver(), invoke.getArguments().get(0), invoke.getArguments().get(1), invoke.getArguments().get(2), invoke.getArguments().get(3));
        getField.insertNext(arrayCopy);
        invoke.delete();
    }

    private void replaceFastCharArray(InvokeInstruction invoke) {
        GetFieldInstruction getField = new GetFieldInstruction();
        getField.setField(new FieldReference("java.lang.String", "characters"));
        getField.setFieldType(ValueType.arrayOf(ValueType.CHARACTER));
        getField.setInstance(invoke.getInstance());
        getField.setReceiver(invoke.getReceiver());
        getField.setLocation(invoke.getLocation());
        invoke.replace(getField);
    }
}

