/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.tz;

import java.util.Properties;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.classlib.impl.tz.DateTimeZoneProvider;
import org.teavm.model.MethodReference;

public class DateTimeZoneProviderIntrinsic
implements Intrinsic,
WasmIntrinsic {
    private Properties properties;

    public DateTimeZoneProviderIntrinsic(Properties properties) {
        this.properties = properties;
    }

    @Override
    public boolean canHandle(MethodReference method) {
        if (!method.getClassName().equals(DateTimeZoneProvider.class.getName())) {
            return false;
        }
        switch (method.getName()) {
            case "timeZoneDetectionEnabled": 
            case "getNativeOffset": {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().equals(DateTimeZoneProvider.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "timeZoneDetectionEnabled": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(IntrinsicContext context, InvocationExpr invocation) {
        switch (invocation.getMethod().getName()) {
            case "timeZoneDetectionEnabled": {
                boolean enabled = this.properties.getProperty("java.util.TimeZone.autodetect", "false").equals("true");
                context.writer().print(enabled ? "1" : "0");
                break;
            }
            case "getNativeOffset": {
                context.includes().includePath("time.h");
                context.writer().print("teavm_timeZoneOffset()");
            }
        }
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "timeZoneDetectionEnabled": {
                boolean enabled = this.properties.getProperty("java.util.TimeZone.autodetect", "false").equals("true");
                return new WasmInt32Constant(enabled ? 1 : 0);
            }
        }
        throw new AssertionError();
    }
}

