/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRCurrency;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.classlib.impl.unicode.CurrencyLocalizationBuilder;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.builders.ResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceMapBuilder;

public class CurrencyLocalizationMetadataGenerator
implements MetadataGenerator {
    @Override
    public ResourceBuilder generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        CLDRReader reader = context.getService(CLDRReader.class);
        ResourceMapBuilder map = new ResourceMapBuilder();
        for (Map.Entry<String, CLDRLocale> localeEntry : reader.getKnownLocales().entrySet()) {
            CLDRLocale locale = localeEntry.getValue();
            ResourceMapBuilder currencies = new ResourceMapBuilder();
            map.values.put(localeEntry.getKey(), currencies);
            for (Map.Entry<String, CLDRCurrency> currencyEntry : locale.getCurrencies().entrySet()) {
                CLDRCurrency currency = currencyEntry.getValue();
                CurrencyLocalizationBuilder localization = new CurrencyLocalizationBuilder();
                localization.name = currency.getName();
                localization.symbol = currency.getSymbol() != null ? currency.getSymbol() : "";
                currencies.values.put(currencyEntry.getKey(), localization);
            }
        }
        return map;
    }
}

