/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRDecimalData;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.classlib.impl.unicode.DecimalDataBuilder;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.builders.ResourceBuilder;
import org.teavm.platform.metadata.builders.ResourceMapBuilder;

public class DecimalMetadataGenerator
implements MetadataGenerator {
    @Override
    public ResourceBuilder generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        CLDRReader reader = context.getService(CLDRReader.class);
        ResourceMapBuilder map = new ResourceMapBuilder();
        for (Map.Entry<String, CLDRLocale> entry : reader.getKnownLocales().entrySet()) {
            CLDRDecimalData data = entry.getValue().getDecimalData();
            DecimalDataBuilder dataRes = new DecimalDataBuilder();
            dataRes.decimalSeparator = data.getDecimalSeparator();
            dataRes.exponentSeparator = data.getExponentSeparator();
            dataRes.groupingSeparator = data.getGroupingSeparator();
            dataRes.infinity = data.getInfinity();
            dataRes.listSeparator = data.getListSeparator();
            dataRes.minusSign = data.getMinusSign();
            dataRes.nan = data.getNaN();
            dataRes.percent = data.getPercent();
            dataRes.perMille = data.getPerMille();
            map.values.put(entry.getKey(), dataRes);
        }
        return map;
    }
}

